/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AlwaysTrue;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Variable;
import java.util.Map;
import java.util.Set;

class NotExpression
extends TypeStateCondition {
    private final TypeStateCondition _not;

    NotExpression(TypeStateCondition typeStateCondition) {
        this._not = typeStateCondition;
    }

    @Override
    public boolean satisfiedVarVal(Map<Variable, Assignment> map) {
        return !this._not.satisfiedVarVal(map);
    }

    @Override
    protected boolean abstractSatisfiedVarVal(Map<Variable, Assignment> map) throws AlwaysTrue {
        return !this._not.abstractSatisfiedVarVal(map);
    }

    @Override
    public boolean isAssignement() {
        return false;
    }

    @Override
    public Assignment getAssignement() {
        throw new UnsupportedOperationException("Unsupported operation 'getAssignement' since this expression is a negation.");
    }

    @Override
    public boolean isNegation() {
        return true;
    }

    @Override
    public TypeStateCondition getNegation() {
        return this._not;
    }

    @Override
    public boolean isAnd() {
        return false;
    }

    @Override
    public TypeStateCondition getAndLeftPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getAndLeftPart' since this expression is a negation.");
    }

    @Override
    public TypeStateCondition getAndRightPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getAndRightPart' since this expression is a negation.");
    }

    @Override
    public boolean isOr() {
        return false;
    }

    @Override
    public TypeStateCondition getOrLeftPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getOrLeftPart' since this expression is a negation.");
    }

    @Override
    public TypeStateCondition getOrRightPart() {
        throw new UnsupportedOperationException("Unsupported operation 'getOrRightPart' since this expression is a negation.");
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean getConstant() {
        throw new UnsupportedOperationException("Unsupported operation 'getConstant' since this expression is a negation.");
    }

    @Override
    public TypeStateCondition negationOnTheLeaves() {
        if (this._not.isNegation()) {
            return this._not.getNegation();
        }
        if (this._not.isAnd()) {
            TypeStateCondition typeStateCondition = this._not.getAndLeftPart();
            TypeStateCondition typeStateCondition2 = this._not.getAndRightPart();
            return TypeStateCondition.or(TypeStateCondition.not(typeStateCondition).negationOnTheLeaves(), TypeStateCondition.not(typeStateCondition2).negationOnTheLeaves());
        }
        if (this._not.isOr()) {
            TypeStateCondition typeStateCondition = this._not.getOrLeftPart();
            TypeStateCondition typeStateCondition3 = this._not.getOrRightPart();
            return TypeStateCondition.and(TypeStateCondition.not(typeStateCondition).negationOnTheLeaves(), TypeStateCondition.not(typeStateCondition3).negationOnTheLeaves());
        }
        return this;
    }

    @Override
    protected TypeStateCondition negToCNF() {
        return this;
    }

    @Override
    protected TypeStateCondition doAbstraction(Set<Variable> set) throws AlwaysTrue {
        return TypeStateCondition.not(this._not.doAbstraction(set));
    }

    @Override
    protected boolean abstractSatisfied(TypeState typeState, int n) throws AlwaysTrue {
        boolean bl = this._not.abstractSatisfied(typeState, n);
        return !bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof NotExpression) {
            return this._not.equals(((NotExpression)object)._not);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 31 * n + (this._not != null ? this._not.hashCode() : 0);
        return n;
    }

    @Override
    public Set<Assignment> getAssignements() {
        return this._not.getAssignements();
    }
}

