/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractOptionable;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Optionable;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class Port
extends AbstractOptionable
implements Comparable,
Optionable {
    private final String _label;
    private final UnmodifiableSet<Message> _messages;
    private final UnmodifiableMap<String, Message> _stringToMessage;
    private final UnmodifiableMap<Message, Event> _messageToEvent;
    private final boolean _isInput;
    private final int _hashCode;
    private final UnmodifiableSet<Event> _events;

    public Port(String string, boolean bl, Collection<Message> collection) {
        this(string, bl, collection, Collections.emptyMap());
    }

    public Port(String string, boolean bl, Collection<Message> collection, Map<String, String> map) {
        this(string, bl, collection, map, Collections.emptyMap());
    }

    public Port(String string, boolean bl, Collection<Message> collection, Map<String, String> map, Map<Message, Map<String, String>> map2) {
        super(map);
        if (string == null) {
            throw new IllegalArgumentException("Impossible to build a Port from a null name (other parameters are: " + bl + " and " + collection.toString() + " ).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Impossible to build a Port from an empty name (other parameters are: " + bl + " and " + collection.toString() + " ).");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Impossible to build a Port from a null collection (other parameters are: " + string + " and " + bl + " ).");
        }
        this._label = string;
        this._isInput = bl;
        UnmodifiableMapConstructor<String, Message> unmodifiableMapConstructor = new UnmodifiableMapConstructor<String, Message>();
        UnmodifiableMapConstructor<Message, Event> unmodifiableMapConstructor2 = new UnmodifiableMapConstructor<Message, Event>();
        UnmodifiableSetConstructor<Event> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Event>();
        for (Message message : collection) {
            unmodifiableMapConstructor.put(message.toString(), message);
            Map<String, String> map3 = map2.get(message);
            if (map3 == null) {
                map3 = Collections.emptyMap();
            }
            Event event = new Event(this, message, map3);
            unmodifiableSetConstructor.add(event);
            unmodifiableMapConstructor2.put(message, event);
        }
        this._messages = new UnmodifiableSetConstructor<Message>(collection).getSet();
        this._events = unmodifiableSetConstructor.getSet();
        this._stringToMessage = unmodifiableMapConstructor.getMap();
        this._messageToEvent = unmodifiableMapConstructor2.getMap();
        this._hashCode = this._label.hashCode();
    }

    public Port(String string, boolean bl, UnmodifiableSet<Message> unmodifiableSet, UnmodifiableMap<String, String> unmodifiableMap, UnmodifiableMap<Message, UnmodifiableMap<String, String>> unmodifiableMap2) {
        super(unmodifiableMap);
        if (string == null) {
            throw new IllegalArgumentException("Impossible to build a Port from a null name (other parameters are: " + bl + " and " + unmodifiableSet.toString() + " ).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Impossible to build a Port from an empty name (other parameters are: " + bl + " and " + unmodifiableSet.toString() + " ).");
        }
        if (unmodifiableSet == null) {
            throw new IllegalArgumentException("Impossible to build a Port from a null collection (other parameters are: " + string + " and " + bl + " ).");
        }
        this._label = string;
        this._isInput = bl;
        UnmodifiableMapConstructor<String, Message> unmodifiableMapConstructor = new UnmodifiableMapConstructor<String, Message>();
        UnmodifiableMapConstructor<Message, Event> unmodifiableMapConstructor2 = new UnmodifiableMapConstructor<Message, Event>();
        UnmodifiableSetConstructor<Event> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Event>();
        for (Message message : unmodifiableSet) {
            unmodifiableMapConstructor.put(message.toString(), message);
            Map<String, String> map = (Map<String, String>)unmodifiableMap2.get(message);
            if (map == null) {
                map = Collections.emptyMap();
            }
            Event event = new Event(this, message, map);
            unmodifiableSetConstructor.add(event);
            unmodifiableMapConstructor2.put(message, event);
        }
        this._messages = unmodifiableSet;
        this._events = unmodifiableSetConstructor.getSet();
        this._stringToMessage = unmodifiableMapConstructor.getMap();
        this._messageToEvent = unmodifiableMapConstructor2.getMap();
        this._hashCode = this._label.hashCode();
    }

    public final String getName() {
        return this._label;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final Message getMessage(String string) {
        return this._stringToMessage.get(string);
    }

    public Event getEvent(Message message) {
        return this._messageToEvent.get(message);
    }

    public final boolean mayOccur(Message message) {
        return this._messages.contains(message);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final boolean connectable(Port port) {
        for (Message message : port.messages()) {
            if (!this._messages.contains(message)) continue;
            return true;
        }
        return false;
    }

    public final boolean compatible(Port port) {
        return this._messages.equals(port._messages);
    }

    public final UnmodifiableSet<Message> messages() {
        return this._messages;
    }

    public final UnmodifiableSet<Event> events() {
        return this._events;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._isInput) {
            stringBuffer.append("Input ");
        } else {
            stringBuffer.append("Ouput ");
        }
        stringBuffer.append("port ").append(this._label).append(this._messages);
        return stringBuffer.toString();
    }

    public String toXml() {
        StringBuffer stringBuffer = new StringBuffer("<Port><PortLabel>").append(this._label).append("</PortLabel>");
        for (Message message : this._messages) {
            stringBuffer.append(message.toXml());
        }
        stringBuffer.append("</Port>");
        return stringBuffer.toString();
    }

    public String shortXml() {
        return "<Port>" + this._label + "</Port>";
    }

    public final boolean isInputPort() {
        return this._isInput;
    }

    public int compareTo(Object object) {
        Port port = (Port)object;
        return this.hashCode() - port.hashCode();
    }
}

