/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.ActivationAction;
import edu.supercom.csdl.ConnectionAction;
import edu.supercom.csdl.ObservableAction;
import edu.supercom.csdl.TopologyCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class ReconfigurationPattern {
    private final String _name;
    private final Collection<String> _variables;
    private final TopologyCondition _cond;
    private final Collection<ActivationAction> _active;
    private final Collection<ActivationAction> _deactive;
    private final Collection<ConnectionAction> _connections;
    private final Collection<ConnectionAction> _deconnections;
    private final Collection<ObservableAction> _observ;
    private final Collection<ObservableAction> _unobserv;

    public ReconfigurationPattern(String string, Collection<String> collection, TopologyCondition topologyCondition, Collection<ActivationAction> collection2, Collection<ActivationAction> collection3, Collection<ConnectionAction> collection4, Collection<ConnectionAction> collection5, Collection<ObservableAction> collection6, Collection<ObservableAction> collection7) {
        this._name = string;
        this._variables = new HashSet<String>(collection);
        this._cond = topologyCondition;
        this._active = new HashSet<ActivationAction>(collection2);
        this._deactive = new HashSet<ActivationAction>(collection3);
        this._connections = new HashSet<ConnectionAction>(collection4);
        this._deconnections = new HashSet<ConnectionAction>(collection5);
        this._observ = new HashSet<ObservableAction>(collection6);
        this._unobserv = new HashSet<ObservableAction>(collection7);
    }

    public String getName() {
        return this._name;
    }

    public Iterator<String> variableIterator() {
        return this.variables().iterator();
    }

    public Collection<String> variables() {
        return Collections.unmodifiableCollection(this._variables);
    }

    public Iterator<ActivationAction> activationIterator() {
        return this.activations().iterator();
    }

    public Collection<ActivationAction> activations() {
        return Collections.unmodifiableCollection(this._active);
    }

    public Iterator<ActivationAction> deactivationIterator() {
        return this.deactivations().iterator();
    }

    public Collection<ActivationAction> deactivations() {
        return Collections.unmodifiableCollection(this._deactive);
    }

    public Iterator<ConnectionAction> connectionIterator() {
        return this.connections().iterator();
    }

    public Collection<ConnectionAction> connections() {
        return Collections.unmodifiableCollection(this._connections);
    }

    public Iterator<ConnectionAction> deconnectionIterator() {
        return this.deconnections().iterator();
    }

    public Collection<ConnectionAction> deconnections() {
        return Collections.unmodifiableCollection(this._deconnections);
    }

    public Iterator<ObservableAction> observationAction() {
        return this.observationActions().iterator();
    }

    public Collection<ObservableAction> observationActions() {
        return Collections.unmodifiableCollection(this._observ);
    }

    public Iterator<ObservableAction> unobservationAction() {
        return this.unobservationActions().iterator();
    }

    public Collection<ObservableAction> unobservationActions() {
        return Collections.unmodifiableCollection(this._unobserv);
    }

    public TopologyCondition getPrecondition() {
        return this._cond;
    }

    public boolean isComponent(String string) {
        if (this._cond.componentVariable(string)) {
            return true;
        }
        for (ActivationAction object : this._active) {
            if (!object.getName().equals(string)) continue;
            return true;
        }
        for (ActivationAction activationAction : this._deactive) {
            if (!activationAction.getName().equals(string)) continue;
            return true;
        }
        for (ConnectionAction connectionAction : this._connections) {
            if (connectionAction.getSourceComponent().equals(string)) {
                return true;
            }
            if (!connectionAction.getTargetComponent().equals(string)) continue;
            return true;
        }
        for (ConnectionAction connectionAction : this._deconnections) {
            if (connectionAction.getSourceComponent().equals(string)) {
                return true;
            }
            if (!connectionAction.getTargetComponent().equals(string)) continue;
            return true;
        }
        for (ObservableAction observableAction : this._observ) {
            if (!observableAction.getCompName().equals(string)) continue;
            return true;
        }
        for (ObservableAction observableAction : this._unobserv) {
            if (!observableAction.getCompName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isPort(String string) {
        if (this._cond.portVariable(string)) {
            return true;
        }
        for (ConnectionAction object : this._connections) {
            if (object.getSourcePort().equals(string)) {
                return true;
            }
            if (!object.getTargetPort().equals(string)) continue;
            return true;
        }
        for (ConnectionAction connectionAction : this._deconnections) {
            if (connectionAction.getSourcePort().equals(string)) {
                return true;
            }
            if (!connectionAction.getTargetPort().equals(string)) continue;
            return true;
        }
        for (ObservableAction observableAction : this._observ) {
            if (!observableAction.getPortName().equals(string)) continue;
            return true;
        }
        for (ObservableAction observableAction : this._unobserv) {
            if (!observableAction.getPortName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

