/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractOptionable;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.LabelGenerator;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.RuleEffect;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Variable;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Rule
extends AbstractOptionable
implements Comparable {
    private static final LabelGenerator _generator = new LabelGenerator();
    private final TypeStateCondition _precond;
    private final Event _trigger;
    private final UnmodifiableSet<Event> _output;
    private final RuleEffect _effect;
    private final String _label;
    private final UnmodifiableMap<Port, Event> _portEvents;

    public Rule(TypeStateCondition typeStateCondition, Event event, Collection<Event> collection, RuleEffect ruleEffect) {
        this(typeStateCondition, event, collection, ruleEffect, Collections.emptyMap());
    }

    public Rule(String string, TypeStateCondition typeStateCondition, Event event, Collection<Event> collection, RuleEffect ruleEffect) {
        this(string, typeStateCondition, event, collection, ruleEffect, Collections.emptyMap());
    }

    public Rule(TypeStateCondition typeStateCondition, Event event, Collection<Event> collection, RuleEffect ruleEffect, Map<String, String> map) {
        this("R" + _generator.generate(), typeStateCondition, event, collection, ruleEffect, map);
    }

    public Rule(String string, TypeStateCondition typeStateCondition, Event event, Collection<Event> collection, RuleEffect ruleEffect, Map<String, String> map) {
        super(map);
        this._precond = typeStateCondition;
        this._effect = ruleEffect;
        UnmodifiableSetConstructor<Event> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Event>();
        UnmodifiableMapConstructor<Port, Event> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Port, Event>();
        HashSet<Port> hashSet = new HashSet<Port>();
        Port port = event.getPort();
        Event event22 = event;
        if (!port.isInputPort()) {
            throw new IllegalArgumentException("The event " + event22.toString() + " cannot be an input event since its port " + port.toString() + " is an output port.");
        }
        this._trigger = event22;
        unmodifiableMapConstructor.addMapping(port, event22);
        for (Event event22 : collection) {
            Port port2 = event22.getPort();
            if (hashSet.contains(port2)) {
                throw new IllegalArgumentException("The port " + port2.toString() + " cannot receive two messages.");
            }
            if (port2.isInputPort()) {
                throw new IllegalArgumentException("The event " + event22.toString() + " cannot be an output event since its port " + port2.toString() + " is an istput port.");
            }
            hashSet.add(port2);
            unmodifiableSetConstructor.add(event22);
            unmodifiableMapConstructor.addMapping(port2, event22);
        }
        this._output = unmodifiableSetConstructor.getSet();
        this._portEvents = unmodifiableMapConstructor.getMap();
        this._label = string;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this._label;
    }

    public TypeStateCondition getPrecondition() {
        return this._precond;
    }

    public Event getTriggeringEvent() {
        return this._trigger;
    }

    public UnmodifiableSet<Event> outputEvents() {
        return this._output;
    }

    public Iterator<Event> outputEventIterator() {
        return this._output.iterator();
    }

    public RuleEffect effect() {
        return this.getEffect();
    }

    public RuleEffect getEffect() {
        return this._effect;
    }

    public boolean satisfied(Map<Variable, Assignment> map, int n) {
        return this._precond.satisfiedVarVal(map, n);
    }

    public boolean satisfied(TypeState typeState) {
        return this._precond.satisfied(typeState);
    }

    public Event getEvent(Port port) {
        return this._portEvents.get(port);
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Rule rule = (Rule)object;
        int n = this.hashCode() - rule.hashCode();
        return n;
    }
}

