/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AlwaysTrue;
import edu.supercom.csdl.AssignementExpression;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.BinaryExpression;
import edu.supercom.csdl.NotExpression;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.ValuatedExpression;
import edu.supercom.csdl.Variable;
import java.util.Map;
import java.util.Set;

public abstract class TypeStateCondition {
    public static final int ALL_VARIABLE_ASSIGNED = 0;
    public static final int STATE_ABSTRACTED = 1;

    public static TypeStateCondition build(boolean bl) {
        return new ValuatedExpression(bl);
    }

    public static TypeStateCondition build(Assignment assignment) {
        return new AssignementExpression(assignment);
    }

    public static TypeStateCondition not(TypeStateCondition typeStateCondition) {
        return new NotExpression(typeStateCondition);
    }

    public static TypeStateCondition and(TypeStateCondition typeStateCondition, TypeStateCondition typeStateCondition2) {
        return new BinaryExpression(true, typeStateCondition, typeStateCondition2);
    }

    public static TypeStateCondition or(TypeStateCondition typeStateCondition, TypeStateCondition typeStateCondition2) {
        return new BinaryExpression(false, typeStateCondition, typeStateCondition2);
    }

    public abstract boolean satisfiedVarVal(Map<Variable, Assignment> var1);

    public final boolean satisfiedVarVal(Map<Variable, Assignment> map, int n) {
        if (n == 0) {
            return this.satisfiedVarVal(map);
        }
        try {
            return this.abstractSatisfiedVarVal(map);
        }
        catch (AlwaysTrue alwaysTrue) {
            return true;
        }
    }

    public final boolean satisfied(TypeState typeState, int n) {
        try {
            return this.abstractSatisfied(typeState, n);
        }
        catch (AlwaysTrue alwaysTrue) {
            return true;
        }
    }

    public final boolean satisfied(TypeState typeState) {
        return this.satisfied(typeState, 0);
    }

    public abstract boolean isAssignement();

    public abstract Assignment getAssignement();

    public abstract boolean isNegation();

    public abstract TypeStateCondition getNegation();

    public abstract boolean isAnd();

    public abstract TypeStateCondition getAndLeftPart();

    public abstract TypeStateCondition getAndRightPart();

    public abstract boolean isOr();

    public abstract TypeStateCondition getOrLeftPart();

    public abstract TypeStateCondition getOrRightPart();

    public abstract boolean isConstant();

    public abstract boolean getConstant();

    public TypeStateCondition abstraction(Set<Variable> set) {
        try {
            return this.doAbstraction(set);
        }
        catch (AlwaysTrue alwaysTrue) {
            return TypeStateCondition.build(true);
        }
    }

    public TypeStateCondition cnf() {
        TypeStateCondition typeStateCondition = this.negationOnTheLeaves();
        return typeStateCondition.negToCNF();
    }

    public abstract TypeStateCondition negationOnTheLeaves();

    protected abstract TypeStateCondition negToCNF();

    protected abstract boolean abstractSatisfiedVarVal(Map<Variable, Assignment> var1) throws AlwaysTrue;

    protected abstract TypeStateCondition doAbstraction(Set<Variable> var1) throws AlwaysTrue;

    protected abstract boolean abstractSatisfied(TypeState var1, int var2) throws AlwaysTrue;

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.getAssignements().hashCode();
    }

    public abstract Set<Assignment> getAssignements();
}

