/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl;

import edu.supercom.csdl.AbstractOptionable;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Domain;
import edu.supercom.csdl.Value;
import edu.supercom.util.UnmodifiableCollection;
import edu.supercom.util.UnmodifiableMap;
import edu.supercom.util.UnmodifiableMapConstructor;
import edu.supercom.util.UnmodifiableSet;
import java.util.Collections;
import java.util.Map;

public class Variable
extends AbstractOptionable
implements Comparable<Variable> {
    private final String _name;
    private final Domain _domain;
    private final UnmodifiableMap<Value, Assignment> _ass;

    public Variable(String string, Domain domain) {
        this(string, domain, Collections.emptyMap());
    }

    public Variable(String string, Domain domain, Map<String, String> map) {
        super(map);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create a variable with a null name.");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Cannot create a variable with a null domain.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Cannot create a variable with an empty name.");
        }
        this._name = string;
        this._domain = domain;
        UnmodifiableMapConstructor<Value, Assignment> unmodifiableMapConstructor = new UnmodifiableMapConstructor<Value, Assignment>();
        for (Value value : this._domain.values()) {
            Assignment assignment = new Assignment(this, value);
            unmodifiableMapConstructor.addMapping(value, assignment);
        }
        this._ass = unmodifiableMapConstructor.getMap();
    }

    public final String getName() {
        return this._name;
    }

    public final Assignment getAssignement(Value value) {
        return this._ass.get(value);
    }

    public final Assignment getAssignement(String string) {
        return this._ass.get(this.getValue(string));
    }

    public final boolean contains(Value value) {
        return this._domain.contains(value);
    }

    public final boolean contains(String string) {
        return this._domain.contains(string);
    }

    public final UnmodifiableSet<Value> values() {
        return this._domain.values();
    }

    public final Domain getDomain() {
        return this._domain;
    }

    public final Value getValue(String string) {
        return this._domain.getValue(string);
    }

    public final Value defaultValue() {
        return this._domain.getDefaultValue();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder("<Variable>");
        stringBuilder.append("<VariableLabel>").append(this._name).append("</VariableLabel>");
        stringBuilder.append(this._domain.toXml());
        stringBuilder.append("</Variable>");
        return stringBuilder.toString();
    }

    public String shortXml() {
        return "<Variable>" + this._name + "</Variable>";
    }

    @Override
    public int compareTo(Variable variable) {
        if (variable == this) {
            return 0;
        }
        int n = this.hashCode() - variable.hashCode();
        return n;
    }

    public UnmodifiableCollection<Assignment> assignments() {
        return this._ass.values();
    }
}

