/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl.parser;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentPort;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Configuration;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.FastAccessTopology;
import edu.supercom.csdl.MapSystemState;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.SeparateConfiguration;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.csdl.parser.CodlParserTokenTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CodlParser
extends LLkParser
implements CodlParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "IDENT", "COMMA", "SEMICOLON", "LBRACKET", "EQUALS", "RBRACKET", "\"Initial\"", "\"configuration\"", "COLON", "\"connect\"", "DOT", "\"observe\"", "WHITESPACE", "CPPCOMMENT"};

    protected CodlParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public CodlParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 3);
    }

    protected CodlParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public CodlParser(TokenStream tokenStream) {
        this(tokenStream, 3);
    }

    public CodlParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 3);
        this.tokenNames = _tokenNames;
    }

    public final void configuration(Map<String, ComponentType> map, Map<String, Component> map2, Configuration[] configurationArray) throws RecognitionException, TokenStreamException {
        this.domain(map, map2);
        this.initialConfiguration(map2, configurationArray);
    }

    public final void domain(Map<String, ComponentType> map, Map<String, Component> map2) throws RecognitionException, TokenStreamException {
        Token token = null;
        while (this.LA(1) == 4) {
            token = this.LT(1);
            this.match(4);
            ComponentType componentType = map.get(token.getText());
            if (componentType == null) {
                System.err.println("Unknown type " + token.toString());
                System.exit(1);
            }
            this.component(componentType, map2);
            while (this.LA(1) == 5) {
                this.match(5);
                this.component(componentType, map2);
            }
            this.match(6);
        }
    }

    public final void initialConfiguration(Map<String, Component> map, Configuration[] configurationArray) throws RecognitionException, TokenStreamException {
        this.match(10);
        this.match(11);
        this.match(12);
        HashSet<Component> hashSet = new HashSet<Component>();
        HashMap<Component, Map<Variable, Value>> hashMap = new HashMap<Component, Map<Variable, Value>>();
        this.activeComponents(map, hashSet, hashMap);
        HashSet<Connection> hashSet2 = new HashSet<Connection>();
        this.connections(map, hashSet2);
        HashSet<ComponentPort> hashSet3 = new HashSet<ComponentPort>();
        this.observablePorts(map, hashSet3);
        FastAccessTopology fastAccessTopology = new FastAccessTopology(hashSet, hashSet2, hashSet3);
        configurationArray[0] = new SeparateConfiguration(fastAccessTopology, new MapSystemState((Topology)fastAccessTopology, hashMap));
    }

    public final void component(ComponentType componentType, Map<String, Component> map) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(4);
        String string = token.getText();
        if (map.containsKey(string)) {
            System.err.println("No two components can have the same name " + token.toString());
            System.exit(1);
        }
        HashMap<Variable, Value> hashMap = new HashMap<Variable, Value>();
        this.assignements(componentType, hashMap);
        Component component = new Component(string, componentType, hashMap);
        map.put(string, component);
    }

    public final void assignements(ComponentType componentType, Map<Variable, Value> map) throws RecognitionException, TokenStreamException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        switch (this.LA(1)) {
            case 7: {
                this.match(7);
                token = this.LT(1);
                this.match(4);
                String string = token.getText();
                Variable variable = componentType.getVariable(string);
                if (variable == null) {
                    System.err.println("Unknown variable " + token.toString());
                    System.exit(1);
                }
                if (map.containsKey(variable)) {
                    System.err.println("Variable already defined " + token.toString());
                    System.exit(1);
                }
                if (componentType.getPort(string) != null) {
                    System.out.println("Cannot set the port variable " + token.toString());
                    System.exit(1);
                }
                this.match(8);
                token2 = this.LT(1);
                this.match(4);
                String string2 = token2.getText();
                Value value = variable.getValue(string2);
                if (value == null) {
                    System.err.println("Unknown value " + token2);
                    System.exit(1);
                }
                map.put(variable, value);
                while (this.LA(1) == 5) {
                    this.match(5);
                    token3 = this.LT(1);
                    this.match(4);
                    string = token3.getText();
                    variable = componentType.getVariable(string);
                    if (variable == null) {
                        System.err.println("Unknown variable " + token3);
                        System.exit(1);
                    }
                    if (map.containsKey(variable)) {
                        System.err.println("Variable already defined " + token3);
                        System.exit(1);
                    }
                    if (componentType.getPort(string) != null) {
                        System.out.println("Cannot set the port variable " + token3.toString());
                        System.exit(1);
                    }
                    this.match(8);
                    token4 = this.LT(1);
                    this.match(4);
                    string2 = token4.getText();
                    value = variable.getValue(string2);
                    if (value == null) {
                        System.err.println("Unknown value " + token4);
                        System.exit(1);
                    }
                    map.put(variable, value);
                }
                this.match(9);
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void activeComponents(Map<String, Component> map, Set<Component> set, Map<Component, Map<Variable, Value>> map2) throws RecognitionException, TokenStreamException {
        Token token = null;
        while (this.LA(1) == 4) {
            token = this.LT(1);
            this.match(4);
            String string = token.getText();
            Component component = map.get(string);
            if (component == null) {
                System.err.println("No such component " + token.toString());
                System.exit(1);
            }
            if (!set.add(component)) {
                System.err.println("Already activated component " + token.toString());
                System.exit(1);
            }
            HashMap<Variable, Value> hashMap = new HashMap<Variable, Value>();
            this.assignements(component.getType(), hashMap);
            map2.put(component, hashMap);
            this.match(6);
        }
    }

    public final void connections(Map<String, Component> map, Set<Connection> set) throws RecognitionException, TokenStreamException {
        Token token = null;
        while (this.LA(1) == 13) {
            this.match(13);
            this.match(7);
            ComponentPort[] componentPortArray = new ComponentPort[1];
            this.port(map, componentPortArray);
            Component component = componentPortArray[0].getComponent();
            Port port = componentPortArray[0].getPort();
            this.match(5);
            this.port(map, componentPortArray);
            Component component2 = componentPortArray[0].getComponent();
            Port port2 = componentPortArray[0].getPort();
            this.match(9);
            token = this.LT(1);
            this.match(6);
            Connection connection = new Connection(component, port, component2, port2);
            if (set.add(connection)) continue;
            System.err.println("Connection already exists " + token.toString());
            System.exit(1);
        }
    }

    public final void observablePorts(Map<String, Component> map, Set<ComponentPort> set) throws RecognitionException, TokenStreamException {
        Token token = null;
        while (this.LA(1) == 15) {
            this.match(15);
            this.match(7);
            ComponentPort[] componentPortArray = new ComponentPort[1];
            this.port(map, componentPortArray);
            this.match(9);
            token = this.LT(1);
            this.match(6);
            if (set.add(componentPortArray[0])) continue;
            System.err.println("Port already set observable " + token.toString());
            System.exit(1);
        }
    }

    public final void port(Map<String, Component> map, ComponentPort[] componentPortArray) throws RecognitionException, TokenStreamException {
        String string;
        Port port;
        Token token = null;
        Token token2 = null;
        token = this.LT(1);
        this.match(4);
        this.match(14);
        token2 = this.LT(1);
        this.match(4);
        String string2 = token.getText();
        Component component = map.get(string2);
        if (component == null) {
            System.err.println("Unknown component " + token.toString());
            System.exit(1);
        }
        if ((port = component.getPort(string = token2.getText())) == null) {
            System.err.println("Unknown port " + token2.toString());
            System.exit(1);
        }
        componentPortArray[0] = component.getComponentPort(port);
    }
}

