/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl.parser;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Domain;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.RuleEffect;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.csdl.parser.DmdlLexer;
import edu.supercom.csdl.parser.DmdlParserTokenTypes;
import edu.supercom.util.UnmodifiableSetConstructor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DmdlParser
extends LLkParser
implements DmdlParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"porttype\"", "IDENT", "EQUALS", "LBRACE", "COMMA", "RBRACE", "SEMICOLON", "\"insert\"", "FILENAME", "LBRACKET", "RBRACKET", "\"input\"", "\"output\"", "\"variables\"", "COLON", "\"in\"", "LSQBRACE", "RSQBRACE", "\"events\"", "\"spontaneous\"", "\"actions\"", "\"rule\"", "\"require\"", "\"or\"", "\"and\"", "\"true\"", "\"not\"", "\"when\"", "DOT", "\"effect\"", "\"safe\"", "WHITESPACE", "WARNING", "CPPCOMMENT1", "CPPCOMMENT2"};

    protected DmdlParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public DmdlParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 3);
    }

    protected DmdlParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public DmdlParser(TokenStream tokenStream) {
        this(tokenStream, 3);
    }

    public DmdlParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 3);
        this.tokenNames = _tokenNames;
    }

    public final void library(String string, CompositeSystem compositeSystem, Map<String, ComponentType> map) throws RecognitionException, TokenStreamException {
        block5: while (true) {
            switch (this.LA(1)) {
                case 11: {
                    this.dmdlfile(string, compositeSystem, map);
                    continue block5;
                }
                case 4: {
                    this.portType(compositeSystem);
                    continue block5;
                }
                case 5: {
                    this.componentType(compositeSystem, map);
                    continue block5;
                }
            }
            break;
        }
    }

    public final void dmdlfile(String string, CompositeSystem compositeSystem, Map<String, ComponentType> map) throws RecognitionException, TokenStreamException {
        Token token = null;
        this.match(11);
        token = this.LT(1);
        this.match(12);
        String string2 = token.getText();
        String string3 = string2.substring(1, string2.length() - 1);
        String string4 = string3.startsWith("/") ? string3 : string + string3;
        try {
            DmdlLexer dmdlLexer = new DmdlLexer(new FileReader(string4));
            DmdlParser dmdlParser = new DmdlParser(dmdlLexer);
            String string5 = new File(string4).getParent() + File.separator;
            dmdlParser.library(string5, compositeSystem, map);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileNotFound exception");
            fileNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Error reading file " + string4);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public final void portType(CompositeSystem compositeSystem) throws RecognitionException, TokenStreamException {
        Token token = null;
        this.match(4);
        token = this.LT(1);
        this.match(5);
        UnmodifiableSetConstructor<Message> unmodifiableSetConstructor = new UnmodifiableSetConstructor<Message>();
        this.match(6);
        this.match(7);
        this.portTypeElement(compositeSystem, unmodifiableSetConstructor);
        while (this.LA(1) == 8) {
            this.match(8);
            this.portTypeElement(compositeSystem, unmodifiableSetConstructor);
        }
        this.match(9);
        this.match(10);
        System.out.println("Port type: " + token.getText());
        System.out.println(unmodifiableSetConstructor.getSet());
    }

    public final void componentType(CompositeSystem compositeSystem, Map<String, ComponentType> map) throws RecognitionException, TokenStreamException {
        String[] stringArray = new String[1];
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        this.head(hashSet, hashSet2, stringArray, hashSet3, map, hashMap);
        String string = stringArray[0];
        this.match(7);
        HashMap<String, Variable> hashMap2 = new HashMap<String, Variable>();
        this.variables(hashMap2, hashSet3);
        HashMap<String, Port> hashMap3 = new HashMap<String, Port>();
        HashMap<String, Port> hashMap4 = new HashMap<String, Port>();
        Port[] portArray = new Port[2];
        this.events(compositeSystem, portArray, hashSet, hashSet2, hashMap3, hashMap4, hashMap);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        this.rules(hashMap2, portArray, hashMap3, hashMap4, hashSet3, arrayList);
        HashMap<Port, TypeStateCondition> hashMap5 = new HashMap<Port, TypeStateCondition>();
        this.safetyRules(hashMap2, hashMap3, hashMap4, hashSet3, hashMap5);
        this.match(9);
        ComponentType componentType = new ComponentType(string, hashMap2.values(), arrayList, hashMap3.values(), hashMap4.values(), portArray[0], portArray[1], hashMap5);
        map.put(string, componentType);
    }

    public final void portTypeElement(CompositeSystem compositeSystem, UnmodifiableSetConstructor<Message> unmodifiableSetConstructor) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(5);
        String string = token.getText();
        Message message = compositeSystem.getMessage(string);
        unmodifiableSetConstructor.add(message);
    }

    public final void head(Collection<String> collection, Collection<String> collection2, String[] stringArray, Collection<String> collection3, Map<String, ComponentType> map, Map<String, Map<String, String>> map2) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(5);
        stringArray[0] = token.getText();
        if (map.containsKey(stringArray[0])) {
            System.err.println("Component type already defined " + token.toString());
            System.exit(1);
        }
        this.match(13);
        this.portDesc(collection, collection2, collection3, map2);
        while (this.LA(1) == 8) {
            this.match(8);
            this.portDesc(collection, collection2, collection3, map2);
        }
        this.match(14);
    }

    public final void variables(Map<String, Variable> map, Collection<String> collection) throws RecognitionException, TokenStreamException {
        this.match(17);
        this.match(18);
        switch (this.LA(1)) {
            case 5: {
                this.variable(map, collection);
                while (this.LA(1) == 8) {
                    this.match(8);
                    this.variable(map, collection);
                }
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void events(CompositeSystem compositeSystem, Port[] portArray, Collection<String> collection, Collection<String> collection2, Map<String, Port> map, Map<String, Port> map2, Map<String, Map<String, String>> map3) throws RecognitionException, TokenStreamException {
        this.match(22);
        this.match(18);
        this.spontaneous(compositeSystem, portArray, collection, collection2);
        this.actions(compositeSystem, portArray, collection, collection2);
        this.portevents(compositeSystem, collection, collection2, map, map2, map3);
    }

    public final void rules(Map<String, Variable> map, Port[] portArray, Map<String, Port> map2, Map<String, Port> map3, Collection<String> collection, Collection<Rule> collection2) throws RecognitionException, TokenStreamException {
        int n = 0;
        while (true) {
            if (this.LA(1) != 25 && this.LA(1) != 26) {
                if (n >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.rule(map, portArray, map2, map3, collection, collection2);
            ++n;
        }
    }

    public final void safetyRules(Map<String, Variable> map, Map<String, Port> map2, Map<String, Port> map3, Collection<String> collection, Map<Port, TypeStateCondition> map4) throws RecognitionException, TokenStreamException {
        Token token = null;
        while (this.LA(1) == 34) {
            this.match(34);
            token = this.LT(1);
            this.match(5);
            TypeStateCondition[] typeStateConditionArray = new TypeStateCondition[1];
            this.sformula(map, collection, typeStateConditionArray);
            Port port = map2.get(token.getText());
            if (port == null) {
                port = map3.get(token.getText());
            }
            if (port == null) {
                System.err.println("Unknown port " + token);
                System.exit(1);
            }
            if (map4.containsKey(port)) {
                System.err.println("The safety rule is already defined for this port " + token);
                System.exit(1);
            }
            map4.put(port, typeStateConditionArray[0]);
        }
    }

    public final void portDesc(Collection<String> collection, Collection<String> collection2, Collection<String> collection3, Map<String, Map<String, String>> map) throws RecognitionException, TokenStreamException {
        boolean bl;
        Token token = null;
        switch (this.LA(1)) {
            case 15: {
                this.match(15);
                bl = true;
                break;
            }
            case 16: {
                this.match(16);
                bl = false;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        token = this.LT(1);
        this.match(5);
        String string = token.getText();
        if (collection.contains(string) || collection2.contains(string)) {
            System.err.println("Cannot create two ports with the same name:" + token);
            System.exit(1);
        }
        if (bl) {
            collection.add(string);
        } else {
            collection2.add(string);
        }
        collection3.add(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.opts(hashMap);
        map.put(string, hashMap);
    }

    public final void opts(Map<String, String> map) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                this.option(map);
                while (this.LA(1) == 8) {
                    this.match(8);
                    this.option(map);
                }
                this.match(21);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void variable(Map<String, Variable> map, Collection<String> collection) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(5);
        if (collection.contains(token.getText())) {
            System.err.println("Cannot create a variable with the same name as a port (this port variable already exists) " + token);
            System.exit(1);
        }
        if (map.containsKey(token.getText())) {
            System.err.println("Cannot create two variables with the same name:" + token);
            System.exit(1);
        }
        ArrayList<Value> arrayList = new ArrayList<Value>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.opts(hashMap);
        this.match(19);
        this.match(7);
        this.value(hashSet, arrayList);
        Value value = (Value)arrayList.get(0);
        while (this.LA(1) == 8) {
            this.match(8);
            this.value(hashSet, arrayList);
        }
        this.match(9);
        Domain domain = new Domain(arrayList, value);
        Variable variable = new Variable(token.getText(), domain, hashMap);
        map.put(token.getText(), variable);
    }

    public final void value(Set<String> set, Collection<Value> collection) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(5);
        String string = token.getText();
        if (!set.add(string)) {
            System.err.println("Value already exists " + string);
            System.exit(1);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.opts(hashMap);
        Value value = new Value(string, hashMap);
        collection.add(value);
    }

    public final void option(Map<String, String> map) throws RecognitionException, TokenStreamException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        if (this.LA(1) == 5 && (this.LA(2) == 8 || this.LA(2) == 21)) {
            token = this.LT(1);
            this.match(5);
            String string = token.getText();
            map.put(string, string);
        } else if (this.LA(1) == 5 && this.LA(2) == 6) {
            token2 = this.LT(1);
            this.match(5);
            this.match(6);
            token3 = this.LT(1);
            this.match(5);
            String string = token2.getText();
            String string2 = token3.getText();
            map.put(string, string2);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void spontaneous(CompositeSystem compositeSystem, Port[] portArray, Collection<String> collection, Collection<String> collection2) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 23: {
                Port port;
                this.match(23);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.opts(hashMap);
                this.match(18);
                HashSet<Message> hashSet = new HashSet<Message>();
                HashMap<Message, Map<String, String>> hashMap2 = new HashMap<Message, Map<String, String>>();
                this.messageList(compositeSystem, hashSet, hashMap2);
                String string = "__SPONTANEOUS__";
                int n = 1;
                while (collection.contains(string) || collection2.contains(string)) {
                    string = "__SPONTANEOUS__" + n;
                    ++n;
                }
                portArray[0] = port = new Port(string, true, hashSet, hashMap, hashMap2);
                this.match(10);
                break;
            }
            case 5: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void actions(CompositeSystem compositeSystem, Port[] portArray, Collection<String> collection, Collection<String> collection2) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 24: {
                Port port;
                this.match(24);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.opts(hashMap);
                this.match(18);
                HashSet<Message> hashSet = new HashSet<Message>();
                HashMap<Message, Map<String, String>> hashMap2 = new HashMap<Message, Map<String, String>>();
                this.messageList(compositeSystem, hashSet, hashMap2);
                String string = "__ACTION__";
                int n = 1;
                while (collection.contains(string) || collection2.contains(string)) {
                    string = "__ACTION__" + n;
                    ++n;
                }
                portArray[1] = port = new Port(string, true, hashSet, hashMap, hashMap2);
                this.match(10);
                break;
            }
            case 5: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void portevents(CompositeSystem compositeSystem, Collection<String> collection, Collection<String> collection2, Map<String, Port> map, Map<String, Port> map2, Map<String, Map<String, String>> map3) throws RecognitionException, TokenStreamException {
        Token token = null;
        Token token2 = null;
        while (this.LA(1) == 5) {
            token = this.LT(1);
            this.match(5);
            Iterator<String> iterator = token.getText();
            boolean bl = collection.remove(iterator);
            if (!bl && !collection2.remove(iterator)) {
                if (map.containsKey(iterator) || map2.containsKey(iterator)) {
                    throw new IllegalStateException("Port already defined " + token);
                }
                throw new IllegalStateException("Unknown port " + token);
            }
            HashSet<Message> hashSet = new HashSet<Message>();
            HashMap<Message, Map<String, String>> hashMap = new HashMap<Message, Map<String, String>>();
            this.match(18);
            this.messageList(compositeSystem, hashSet, hashMap);
            Port port = new Port((String)((Object)iterator), bl, (Collection<Message>)hashSet, map3.get(iterator), (Map<Message, Map<String, String>>)hashMap);
            if (bl) {
                map.put((String)((Object)iterator), port);
            } else {
                map2.put((String)((Object)iterator), port);
            }
            token2 = this.LT(1);
            this.match(10);
        }
        if (!collection.isEmpty() || !collection2.isEmpty()) {
            System.err.println("Undefined ports:");
            for (String string : collection) {
                System.err.println("  - " + string);
            }
            for (String string : collection2) {
                System.err.println("  - " + string);
            }
            System.err.println("Line " + token2.getLine());
            System.exit(1);
        }
    }

    public final void messageList(CompositeSystem compositeSystem, Collection<Message> collection, Map<Message, Map<String, String>> map) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 5: {
                this.message(compositeSystem, collection, map);
                while (this.LA(1) == 8) {
                    this.match(8);
                    this.message(compositeSystem, collection, map);
                }
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void message(CompositeSystem compositeSystem, Collection<Message> collection, Map<Message, Map<String, String>> map) throws RecognitionException, TokenStreamException {
        Token token = null;
        token = this.LT(1);
        this.match(5);
        String string = token.getText();
        Message message = compositeSystem.getMessage(string);
        collection.add(message);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.opts(hashMap);
        map.put(message, hashMap);
    }

    public final void rule(Map<String, Variable> map, Port[] portArray, Map<String, Port> map2, Map<String, Port> map3, Collection<String> collection, Collection<Rule> collection2) throws RecognitionException, TokenStreamException {
        Token token = null;
        TypeStateCondition[] typeStateConditionArray = new TypeStateCondition[1];
        String string = null;
        switch (this.LA(1)) {
            case 25: {
                this.match(25);
                token = this.LT(1);
                this.match(5);
                string = token.getText();
                break;
            }
            case 26: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.requirement(map, collection, typeStateConditionArray);
        TypeStateCondition typeStateCondition = typeStateConditionArray[0];
        Event[] eventArray = new Event[1];
        this.trigger(portArray, map2, eventArray);
        Event event = eventArray[0];
        HashMap<Port, Event> hashMap = new HashMap<Port, Event>();
        this.outputs(map3, hashMap);
        HashSet<Event> hashSet = new HashSet<Event>(hashMap.values());
        HashMap<Variable, Value> hashMap2 = new HashMap<Variable, Value>();
        this.effect(map, collection, hashMap2);
        RuleEffect ruleEffect = new RuleEffect(hashMap2);
        Rule rule = string == null ? new Rule(typeStateCondition, event, hashSet, ruleEffect) : new Rule(string, typeStateCondition, event, hashSet, ruleEffect);
        collection2.add(rule);
    }

    public final void requirement(Map<String, Variable> map, Collection<String> collection, TypeStateCondition[] typeStateConditionArray) throws RecognitionException, TokenStreamException {
        this.match(26);
        this.sformula(map, collection, typeStateConditionArray);
    }

    public final void trigger(Port[] portArray, Map<String, Port> map, Event[] eventArray) throws RecognitionException, TokenStreamException {
        Event event;
        Message message;
        String string;
        Token token = null;
        Token token2 = null;
        this.match(31);
        Port port = null;
        if (this.LA(1) == 5 && this.LA(2) == 32) {
            token = this.LT(1);
            this.match(5);
            string = token.getText();
            port = map.get(string);
            if (port == null) {
                System.err.println("No such input port " + token.toString());
                System.exit(1);
            }
            this.match(32);
        } else if (this.LA(1) != 5 || this.LA(2) != 16 && this.LA(2) != 33) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        token2 = this.LT(1);
        this.match(5);
        string = token2.getText();
        if (port == null && ((port = portArray[0]) == null || port.getMessage(string) == null)) {
            port = portArray[2];
        }
        if (port == null) {
            System.err.println("No event and action port " + token2.toString());
            System.exit(1);
        }
        if ((message = port.getMessage(string)) == null) {
            System.err.println("No such message " + token2.toString());
            System.exit(1);
        }
        eventArray[0] = event = port.getEvent(message);
    }

    public final void outputs(Map<String, Port> map, Map<Port, Event> map2) throws RecognitionException, TokenStreamException {
        Token token = null;
        Token token2 = null;
        while (this.LA(1) == 16) {
            String string;
            Message message;
            this.match(16);
            token = this.LT(1);
            this.match(5);
            this.match(32);
            token2 = this.LT(1);
            this.match(5);
            String string2 = token.getText();
            Port port = map.get(string2);
            if (port == null) {
                System.err.println("No such output port " + token);
                System.exit(1);
            }
            if (map2.containsKey(port)) {
                System.err.println("No two events can occur on the same output port " + token);
                System.exit(1);
            }
            if ((message = port.getMessage(string = token2.getText())) == null) {
                System.err.println("No such message " + token2 + " on port " + port.getName());
                System.exit(1);
            }
            Event event = port.getEvent(message);
            map2.put(port, event);
        }
    }

    public final void effect(Map<String, Variable> map, Collection<String> collection, Map<Variable, Value> map2) throws RecognitionException, TokenStreamException {
        Token token = null;
        this.match(33);
        this.match(13);
        switch (this.LA(1)) {
            case 5: {
                Assignment[] assignmentArray = new Assignment[1];
                this.assignment(map, false, collection, assignmentArray);
                map2.put(assignmentArray[0].getVariable(), assignmentArray[0].getValue());
                while (this.LA(1) == 28) {
                    token = this.LT(1);
                    this.match(28);
                    this.assignment(map, false, collection, assignmentArray);
                    if (map2.put(assignmentArray[0].getVariable(), assignmentArray[0].getValue()) == null) continue;
                    System.err.println("Impossible to set the same variable " + assignmentArray[0].getVariable() + " with two different values " + token.toString());
                    System.exit(1);
                }
                break;
            }
            case 29: {
                this.match(29);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(14);
    }

    public final void sformula(Map<String, Variable> map, Collection<String> collection, TypeStateCondition[] typeStateConditionArray) throws RecognitionException, TokenStreamException {
        this.sformula2(map, collection, typeStateConditionArray);
        switch (this.LA(1)) {
            case 27: {
                TypeStateCondition typeStateCondition;
                TypeStateCondition typeStateCondition2 = typeStateConditionArray[0];
                typeStateConditionArray[0] = null;
                this.match(27);
                this.sformula(map, collection, typeStateConditionArray);
                TypeStateCondition typeStateCondition3 = typeStateConditionArray[0];
                typeStateConditionArray[0] = typeStateCondition = TypeStateCondition.or(typeStateCondition2, typeStateCondition3);
                break;
            }
            case 9: 
            case 14: 
            case 31: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void sformula2(Map<String, Variable> map, Collection<String> collection, TypeStateCondition[] typeStateConditionArray) throws RecognitionException, TokenStreamException {
        this.atomicformula(map, collection, typeStateConditionArray);
        switch (this.LA(1)) {
            case 28: {
                TypeStateCondition typeStateCondition;
                TypeStateCondition typeStateCondition2 = typeStateConditionArray[0];
                typeStateConditionArray[0] = null;
                this.match(28);
                this.sformula2(map, collection, typeStateConditionArray);
                TypeStateCondition typeStateCondition3 = typeStateConditionArray[0];
                typeStateConditionArray[0] = typeStateCondition = TypeStateCondition.and(typeStateCondition2, typeStateCondition3);
                break;
            }
            case 9: 
            case 14: 
            case 27: 
            case 31: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void atomicformula(Map<String, Variable> map, Collection<String> collection, TypeStateCondition[] typeStateConditionArray) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 29: {
                this.match(29);
                typeStateConditionArray[0] = TypeStateCondition.build(true);
                break;
            }
            case 5: {
                Assignment[] assignmentArray = new Assignment[1];
                this.assignment(map, true, collection, assignmentArray);
                typeStateConditionArray[0] = TypeStateCondition.build(assignmentArray[0]);
                break;
            }
            case 13: {
                this.match(13);
                this.sformula(map, collection, typeStateConditionArray);
                this.match(14);
                break;
            }
            case 30: {
                this.match(30);
                this.atomicformula(map, collection, typeStateConditionArray);
                typeStateConditionArray[0] = TypeStateCondition.not(typeStateConditionArray[0]);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void assignment(Map<String, Variable> map, boolean bl, Collection<String> collection, Assignment[] assignmentArray) throws RecognitionException, TokenStreamException {
        Assignment assignment;
        Variable variable;
        Token token = null;
        Token token2 = null;
        token = this.LT(1);
        this.match(5);
        this.match(6);
        token2 = this.LT(1);
        this.match(5);
        String string = token.getText();
        if (!bl && collection.contains(string)) {
            System.err.println("Cannot modify the port variable " + token.toString());
            System.exit(1);
        }
        if ((variable = map.get(string)) == null) {
            if (bl && collection.contains(string)) {
                variable = new Variable(string, Domain.portVariablesDomain());
                map.put(string, variable);
            } else {
                System.err.println("Unknown variable " + token);
                System.exit(1);
            }
        }
        if ((assignment = variable.getAssignement(token2.getText())) == null) {
            System.err.println("Unknown value " + token2);
            System.exit(1);
        }
        assignmentArray[0] = assignment;
    }

    public final void assignmentList(Map<String, Variable> map, Collection<String> collection, Map<Variable, Value> map2) throws RecognitionException, TokenStreamException {
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        Assignment[] assignmentArray = new Assignment[1];
        this.assignment(map, false, collection, assignmentArray);
        arrayList.add(assignmentArray[0]);
        while (this.LA(1) == 28) {
            this.match(28);
            this.assignment(map, false, collection, assignmentArray);
            arrayList.add(assignmentArray[0]);
        }
        for (Assignment assignment : arrayList) {
            map2.put(assignment.getVariable(), assignment.getValue());
        }
    }
}

