/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl.topcond;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.TopologyCondition;
import edu.supercom.csdl.topcond.AbstractTopologyCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ActiveComponent
extends AbstractTopologyCondition
implements TopologyCondition {
    private final String _name;
    private final boolean _isVariable;
    private final Collection<String> _variables;

    public ActiveComponent(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("The name of a component in a ActiveComponent cannot be null.");
        }
        this._name = string;
        this._isVariable = bl;
        HashSet<String> hashSet = new HashSet<String>();
        if (bl) {
            hashSet.add(string);
        }
        this._variables = Collections.unmodifiableCollection(hashSet);
    }

    @Override
    public boolean isSatisfied(Topology topology, Map<String, String> map) {
        String string = this._isVariable ? map.get(this._name) : this._name;
        return topology.getComponent(string) != null;
    }

    @Override
    public Collection<String> variables() {
        return this._variables;
    }

    @Override
    public Collection<String> possibleValues(Collection<String> collection, Collection<String> collection2, String string, Topology topology, Map<String, String> map) {
        if (this._name.equals(string)) {
            Iterator<String> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Component component = topology.getComponent(string2);
                if (component != null && topology.isActive(component)) continue;
                iterator.remove();
            }
            return collection2;
        }
        return collection2;
    }

    @Override
    public boolean portVariable(String string) {
        return false;
    }

    @Override
    public boolean componentVariable(String string) {
        return this._isVariable && string.equals(this._name);
    }

    public String name() {
        return this._name;
    }
}

