/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.csdl.topcond;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.TopologyCondition;
import edu.supercom.csdl.topcond.AbstractTopologyCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ConnectionExist
extends AbstractTopologyCondition
implements TopologyCondition {
    private final String _sourceComp;
    private final String _targetComp;
    private final String _sourcePort;
    private final String _targetPort;
    private final boolean _isSourceCompVariable;
    private final boolean _isTargetCompVariable;
    private final boolean _isSourcePortVariable;
    private final boolean _isTargetPortVariable;
    private final Collection<String> _variables;

    public ConnectionExist(String string, String string2, String string3, String string4, Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        this._sourceComp = string;
        boolean bl = false;
        if (string != null && collection.contains(string)) {
            hashSet.add(string);
            bl = true;
        }
        this._isSourceCompVariable = bl;
        this._targetComp = string3;
        bl = false;
        if (string3 != null && collection.contains(string3)) {
            hashSet.add(string3);
            bl = true;
        }
        this._isTargetCompVariable = bl;
        this._sourcePort = string2;
        bl = false;
        if (string2 != null && collection.contains(string2)) {
            hashSet.add(string2);
            bl = true;
        }
        this._isSourcePortVariable = bl;
        this._targetPort = string4;
        bl = false;
        if (string4 != null && collection.contains(string4)) {
            hashSet.add(string4);
            bl = true;
        }
        this._isTargetPortVariable = bl;
        this._variables = Collections.unmodifiableCollection(hashSet);
    }

    @Override
    public boolean isSatisfied(Topology topology, Map<String, String> map) {
        String string;
        String string2;
        String string3;
        String string4;
        if (this._isSourceCompVariable) {
            string4 = map.get(this._sourceComp);
            if (string4 == null) {
                throw new IllegalArgumentException("The variable " + this._sourceComp + " was not instantiated.");
            }
        } else {
            string4 = this._sourceComp;
        }
        if (this._isSourcePortVariable) {
            string3 = map.get(this._sourcePort);
            if (string3 == null) {
                throw new IllegalArgumentException("The variable " + this._sourcePort + " was not instantiated.");
            }
        } else {
            string3 = this._sourcePort;
        }
        if (this._isTargetCompVariable) {
            string2 = map.get(this._targetComp);
            if (string2 == null) {
                throw new IllegalArgumentException("The variable " + this._targetComp + " was not instantiated.");
            }
        } else {
            string2 = this._targetComp;
        }
        if (this._isTargetPortVariable) {
            string = map.get(this._targetPort);
            if (string == null) {
                throw new IllegalArgumentException("The variable " + this._targetPort + " was not instantiated.");
            }
        } else {
            string = this._targetPort;
        }
        if (string2 != null && string != null) {
            Component component = topology.getComponent(string2);
            if (component == null) {
                return false;
            }
            Port port = component.getInputPort(string);
            if (port == null) {
                return false;
            }
            Connection connection = topology.getConnection(component, port);
            if (connection == null) {
                return false;
            }
            if (string4 != null && !string4.equals(connection.getSourceComponent().getName())) {
                return false;
            }
            return string3 == null || string3.equals(connection.getSourcePort().getName());
        }
        if (string2 != null) {
            Component component = topology.getComponent(string2);
            for (Connection connection : topology.targetConnections(component)) {
                if (string4 != null && !string4.equals(connection.getSourceComponent().getName()) || string3 != null && !string3.equals(connection.getSourcePort().getName())) continue;
                return true;
            }
            return false;
        }
        if (string4 != null && string3 != null) {
            Component component = topology.getComponent(string4);
            if (component == null) {
                return false;
            }
            Port port = component.getInputPort(string3);
            for (Connection connection : topology.connections(component, port)) {
                if (string != null && !string.equals(connection.getTargetPort().getName())) continue;
                return true;
            }
            return false;
        }
        if (string4 != null) {
            Component component = topology.getComponent(string4);
            if (component == null) {
                return false;
            }
            for (Connection connection : topology.sourceConnections(component)) {
                if (string != null && !string.equals(connection.getTargetPort().getName())) continue;
                return true;
            }
            return false;
        }
        for (Connection connection : topology.connections()) {
            if (string3 != null && !string3.equals(connection.getSourcePort().getName()) || string != null && !string.equals(connection.getTargetPort().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> possibleValues(Collection<String> collection, Collection<String> collection2, String string, Topology topology, Map<String, String> map) {
        Object object;
        boolean bl;
        Object object2;
        boolean bl2;
        String string2;
        boolean bl3;
        String string3;
        boolean bl4;
        String string4 = this._sourceComp;
        boolean bl5 = this._isSourceCompVariable;
        boolean bl6 = bl4 = this._isSourceCompVariable && string4.equals(string);
        if (bl5 && (string3 = map.get(string4)) != null) {
            string4 = string3;
            bl5 = false;
        }
        string3 = this._targetComp;
        boolean bl7 = this._isTargetCompVariable;
        boolean bl8 = bl3 = this._isTargetCompVariable && string3.equals(string);
        if (bl7 && (string2 = map.get(string3)) != null) {
            string3 = string2;
            bl7 = false;
        }
        string2 = this._sourcePort;
        boolean bl9 = this._isSourcePortVariable;
        boolean bl10 = bl2 = this._isSourcePortVariable && string2.equals(string);
        if (bl9 && (object2 = map.get(string2)) != null) {
            string2 = object2;
            bl9 = false;
        }
        object2 = this._targetPort;
        boolean bl11 = this._isTargetPortVariable;
        boolean bl12 = bl = this._isTargetPortVariable && ((String)object2).equals(string);
        if (bl11 && (object = map.get(object2)) != null) {
            object2 = object;
            bl11 = false;
        }
        if (!(bl4 || bl3 || bl2 || bl)) {
            return collection2;
        }
        object = collection2.iterator();
        while (object.hasNext()) {
            Comparable comparable;
            Iterator<Connection> iterator;
            String string5;
            String string6 = (String)object.next();
            if (bl4) {
                string4 = string6;
            }
            if (bl3) {
                string3 = string6;
            }
            if (bl2) {
                string2 = string6;
            }
            if (bl) {
                object2 = string6;
            }
            if ((string5 = !bl5 || bl4 ? string4 : (!bl7 || bl3 ? string3 : null)) == null) {
                iterator = topology.connections().iterator();
            } else {
                comparable = topology.getComponent(string5);
                if (comparable == null) {
                    object.remove();
                    continue;
                }
                iterator = topology.connections((Component)comparable).iterator();
            }
            boolean bl13 = false;
            while (iterator.hasNext()) {
                comparable = iterator.next();
                if ((!bl5 || bl4) && !((Connection)comparable).getSourceComponent().getName().equals(string4) || (!bl7 || bl3) && !((Connection)comparable).getTargetComponent().getName().equals(string3) || (!bl9 || bl2) && !((Connection)comparable).getSourcePort().getName().equals(string2) || (!bl11 || bl) && !((Connection)comparable).getTargetPort().getName().equals(object2)) continue;
                bl13 = true;
            }
            if (bl13) continue;
            object.remove();
        }
        return collection2;
    }

    @Override
    public boolean portVariable(String string) {
        if (this._isSourcePortVariable && string.equals(this._sourcePort)) {
            return true;
        }
        return this._isTargetCompVariable && string.equals(this._targetPort);
    }

    @Override
    public boolean componentVariable(String string) {
        if (this._isSourceCompVariable && string.equals(this._sourceComp)) {
            return true;
        }
        return this._isTargetCompVariable && string.equals(this._targetComp);
    }

    @Override
    public Collection<String> variables() {
        return this._variables;
    }
}

