/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat;

import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.ComponentRule;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Domain;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Topology;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.sem.EventOccurrence;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.Equivalence;
import edu.supercom.util.EquivalenceClass;
import edu.supercom.util.sat.VariableAssigner;
import edu.supercom.util.sat.VariableLoader;
import edu.supercom.util.sat.VariableSemantics;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CompositeSystemAssigner2
implements VariableAssigner {
    protected final String _suffix;
    protected final CompositeSystem _cs;
    protected final Topology _top;
    protected final Map<Integer, Integer> _assTimeShift;
    protected final Map<Component, Map<Assignment, Integer>> _assShift;
    protected final Map<Integer, Integer> _evtTimeShift;
    protected final Map<Component, Map<Event, Integer>> _evtShift;
    protected final Map<Component, Map<Rule, Integer>> _rulShift;
    protected final Set<Assignment> _negatedAssignements;
    protected final int _nbAss;
    protected final int _nbEvtAndRul;
    protected final VariableLoader _loader;
    protected final Subsystem _comps;
    protected final boolean _equiv;

    private void removeEventsFromPort(Equivalence<Object> equivalence, Component component, Port port) {
        for (Event event : port.events()) {
            ComponentEvent componentEvent = component.getComponentEvent(event);
            EquivalenceClass<Object> equivalenceClass = equivalence.equivalenceClass(componentEvent);
            equivalence.removeAll(equivalenceClass);
        }
    }

    private void removeNotSynchronousEvents(Equivalence<Object> equivalence, Component component, Port port, Component component2, Port port2) {
        ComponentEvent componentEvent;
        for (Message message : port.messages()) {
            if (port2.mayOccur(message)) continue;
            componentEvent = component.getComponentEvent(port.getEvent(message));
            equivalence.removeAll(equivalence.equivalenceClass(componentEvent));
        }
        for (Message message : port2.messages()) {
            if (port.mayOccur(message)) continue;
            componentEvent = component2.getComponentEvent(port2.getEvent(message));
            equivalence.removeAll(equivalence.equivalenceClass(componentEvent));
        }
    }

    private void mergeCommonEvents(Equivalence<Object> equivalence, Component component, Port port, Component component2, Port port2) {
        for (Message message : port.messages()) {
            if (!port2.mayOccur(message)) continue;
            equivalence.equivalent(component.getComponentEvent(port.getEvent(message)), component2.getComponentEvent(port2.getEvent(message)));
        }
    }

    private int[] init() {
        Object object;
        Object object622;
        int n = 0;
        for (Iterator iterator : this._comps) {
            object622 = ((Component)((Object)iterator)).getType();
            HashMap<Assignment, Integer> object52 = new HashMap<Assignment, Integer>();
            this._assShift.put((Component)((Object)iterator), object52);
            for (Variable variable : ((ComponentType)object622).variables()) {
                Domain domain = variable.getDomain();
                int n2 = domain.size();
                if (n2 == 2) {
                    object = domain.values().iterator();
                    Value value = (Value)object.next();
                    Value value2 = (Value)object.next();
                    int n3 = n++;
                    object52.put(variable.getAssignement(value), new Integer(n3));
                    object52.put(variable.getAssignement(value2), new Integer(n3));
                    this._negatedAssignements.add(variable.getAssignement(value2));
                    continue;
                }
                for (Value value : domain.values()) {
                    int n4 = n++;
                    object52.put(variable.getAssignement(value), new Integer(n4));
                }
            }
        }
        Equivalence equivalence = new Equivalence();
        for (Object object622 : this._comps) {
            ComponentType componentType = ((Component)object622).getType();
            this._rulShift.put((Component)object622, new HashMap());
            this._evtShift.put((Component)object622, new HashMap());
            for (Rule rule : componentType.rules()) {
                ComponentRule componentRule = ((Component)object622).getComponentRule(rule);
                equivalence.add(componentRule);
            }
            for (Event event : componentType.events()) {
                ComponentEvent componentEvent = ((Component)object622).getComponentEvent(event);
                equivalence.add(componentEvent);
            }
        }
        if (this._equiv) {
            for (Object object622 : this._comps) {
                for (Port port : ((Component)object622).inputPorts()) {
                    Connection connection = this._top.getConnection((Component)object622, port);
                    if (connection == null) {
                        this.removeEventsFromPort(equivalence, (Component)object622, port);
                        continue;
                    }
                    this.removeNotSynchronousEvents(equivalence, (Component)object622, port, connection.getSourceComponent(), connection.getSourcePort());
                    if (!this._comps.containsComponent(connection.getSourceComponent())) {
                        for (Connection connection2 : this._top.connections(connection.getSourceComponent(), connection.getSourcePort())) {
                            if (connection2.getTargetComponent().equals(object622)) continue;
                            this.removeNotSynchronousEvents(equivalence, (Component)object622, port, connection2.getTargetComponent(), connection2.getTargetPort());
                            if (!this._comps.containsComponent(connection2.getTargetComponent())) continue;
                            this.mergeCommonEvents(equivalence, (Component)object622, port, connection2.getTargetComponent(), connection2.getTargetPort());
                        }
                        continue;
                    }
                    this.mergeCommonEvents(equivalence, (Component)object622, port, connection.getSourceComponent(), connection.getSourcePort());
                }
                for (Port port : ((Component)object622).outputPorts()) {
                    for (Connection connection : this._top.connections((Component)object622, port)) {
                        if (!this._comps.containsComponent(connection.getTargetComponent())) continue;
                        this.removeNotSynchronousEvents(equivalence, (Component)object622, port, connection.getTargetComponent(), connection.getTargetPort());
                    }
                }
            }
            for (Object object622 : this._comps) {
                ComponentType componentType = ((Component)object622).getType();
                HashMap<Object, ComponentEvent> hashMap = new HashMap<Object, ComponentEvent>();
                for (Event event : componentType.events()) {
                    ComponentEvent componentEvent = ((Component)object622).getComponentEvent(event);
                    if (!equivalence.contains(componentEvent) || event.getPort().containsOption("optional") || event.containsOption("optional")) continue;
                    object = new HashSet();
                    for (Rule rule : event.getPort().isInputPort() ? componentType.triggeringRules(event) : componentType.generatingRules(event)) {
                        ComponentRule componentRule = ((Component)object622).getComponentRule(rule);
                        if (!equivalence.contains(componentRule)) continue;
                        object.add(componentRule);
                    }
                    if (object.isEmpty()) {
                        equivalence.remove(componentEvent);
                    }
                    if (object.size() == 1) {
                        ComponentRule componentRule = (ComponentRule)object.iterator().next();
                        equivalence.equivalent(componentRule, componentEvent);
                        continue;
                    }
                    ComponentEvent componentEvent2 = (ComponentEvent)hashMap.get(object);
                    if (componentEvent2 != null) {
                        equivalence.merge(componentEvent, componentEvent2);
                        continue;
                    }
                    hashMap.put(object, componentEvent);
                }
            }
            for (Object object622 : this._comps) {
                ComponentType componentType = ((Component)object622).getType();
                for (Rule rule : componentType.rules()) {
                    boolean bl = this._top.canBeTriggered((Component)object622, rule);
                    if (bl) continue;
                    ComponentRule componentRule = ((Component)object622).getComponentRule(rule);
                    equivalence.remove(componentRule);
                }
            }
        }
        int n5 = 0;
        for (EquivalenceClass equivalenceClass : equivalence.classes()) {
            int n6 = n5++;
            for (Object e : equivalenceClass) {
                Comparable<ComponentRule> comparable;
                if (e instanceof ComponentRule) {
                    comparable = (ComponentRule)e;
                    this._rulShift.get(((ComponentRule)comparable).getComponent()).put(((ComponentRule)comparable).getRule(), new Integer(n6));
                    continue;
                }
                comparable = (ComponentEvent)e;
                this._evtShift.get(((ComponentEvent)comparable).getComponent()).put(((ComponentEvent)comparable).getEvent(), new Integer(n6));
            }
        }
        object622 = new int[]{n, n5};
        return object622;
    }

    public CompositeSystemAssigner2(CompositeSystem compositeSystem, VariableLoader variableLoader) {
        this(compositeSystem, variableLoader, true);
    }

    public CompositeSystemAssigner2(CompositeSystem compositeSystem, VariableLoader variableLoader, boolean bl) {
        this._suffix = "";
        this._equiv = bl;
        this._cs = compositeSystem;
        this._comps = compositeSystem.getInitialTopology().activeSubsystem();
        this._loader = variableLoader;
        this._top = compositeSystem.getInitialTopology();
        this._assShift = new HashMap<Component, Map<Assignment, Integer>>();
        this._rulShift = new HashMap<Component, Map<Rule, Integer>>();
        this._evtShift = new HashMap<Component, Map<Event, Integer>>();
        this._negatedAssignements = new HashSet<Assignment>();
        int[] nArray = this.init();
        this._nbAss = nArray[0];
        this._nbEvtAndRul = nArray[1];
        this._assTimeShift = new HashMap<Integer, Integer>();
        this._evtTimeShift = new HashMap<Integer, Integer>();
    }

    @Override
    public int surelyGetVariable(VariableSemantics variableSemantics) {
        int n = this.getVariable(variableSemantics);
        if (n == 0) {
            throw new NoSuchElementException("No propositional variable found in this assigner for semantics " + variableSemantics + ".");
        }
        return n;
    }

    public void allocate(int n, int n2) {
        Integer n3;
        int n4;
        for (n4 = n; n4 <= n2; ++n4) {
            n3 = new Integer(n4);
            if (this._assTimeShift.containsKey(n3)) continue;
            this._assTimeShift.put(n3, new Integer(this._loader.allocate(this._nbAss)));
        }
        for (n4 = n; n4 < n2; ++n4) {
            n3 = new Integer(n4);
            if (this._evtTimeShift.containsKey(n3)) continue;
            this._evtTimeShift.put(n3, new Integer(this._loader.allocate(this._nbEvtAndRul)));
        }
    }

    @Override
    public int getVariable(VariableSemantics variableSemantics) {
        if (variableSemantics instanceof TimedAssignement) {
            TimedAssignement timedAssignement = (TimedAssignement)variableSemantics;
            Component component = timedAssignement.getComponent();
            Assignment assignment = timedAssignement.getAssignement();
            int n = timedAssignement.getTime();
            Map<Assignment, Integer> map = this._assShift.get(component);
            if (map == null) {
                return 0;
            }
            Integer n2 = map.get(assignment);
            if (n2 == null) {
                return 0;
            }
            Integer n3 = this._assTimeShift.get(new Integer(n));
            if (n3 == null) {
                return 0;
            }
            int n4 = this._negatedAssignements.contains(assignment) ? -1 : 1;
            return (n2 + n3) * n4;
        }
        if (variableSemantics instanceof EventOccurrence) {
            EventOccurrence eventOccurrence = (EventOccurrence)variableSemantics;
            Component component = eventOccurrence.getComponent();
            Event event = eventOccurrence.getEvent();
            int n = eventOccurrence.getTime();
            Map<Event, Integer> map = this._evtShift.get(component);
            if (map == null) {
                return 0;
            }
            Integer n5 = map.get(event);
            if (n5 == null) {
                return 0;
            }
            Integer n6 = this._evtTimeShift.get(new Integer(n));
            if (n6 == null) {
                return 0;
            }
            return n5 + n6;
        }
        if (variableSemantics instanceof RuleTrigger) {
            RuleTrigger ruleTrigger = (RuleTrigger)variableSemantics;
            Component component = ruleTrigger.getComponent();
            Rule rule = ruleTrigger.getRule();
            int n = ruleTrigger.getTime();
            Map<Rule, Integer> map = this._rulShift.get(component);
            if (map == null) {
                return 0;
            }
            Integer n7 = map.get(rule);
            if (n7 == null) {
                return 0;
            }
            Integer n8 = this._evtTimeShift.get(new Integer(n));
            if (n8 == null) {
                return 0;
            }
            return n7 + n8;
        }
        return 0;
    }

    @Override
    public void print(PrintStream printStream) {
        int n;
        VariableSemantics variableSemantics;
        Map<Comparable<Assignment>, Integer> map;
        if (printStream == null) {
            return;
        }
        for (int n2 : this._assTimeShift.keySet()) {
            for (Component component : this._comps) {
                map = this._assShift.get(component);
                for (Assignment comparable : map.keySet()) {
                    variableSemantics = new TimedAssignement(component, comparable, n2);
                    n = this.getVariable(variableSemantics);
                    printStream.println(n + "\t" + variableSemantics + this._suffix);
                }
            }
        }
        for (int n2 : this._evtTimeShift.keySet()) {
            for (Component component : this._comps) {
                map = this._evtShift.get(component);
                for (Event event : map.keySet()) {
                    variableSemantics = new EventOccurrence(component, event, n2);
                    n = this.getVariable(variableSemantics);
                    printStream.println(n + "\t" + variableSemantics + this._suffix);
                }
            }
        }
        for (int n2 : this._evtTimeShift.keySet()) {
            for (Component component : this._comps) {
                map = this._rulShift.get(component);
                for (Rule rule : map.keySet()) {
                    variableSemantics = new RuleTrigger(component, rule, n2);
                    n = this.getVariable(variableSemantics);
                    printStream.println(n + "\t" + variableSemantics + this._suffix);
                }
            }
        }
    }
}

