/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat;

import edu.supercom.csdl.AbstractTopology;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Topology;
import edu.supercom.diag.sat.CompositeSystemAssigner2;
import edu.supercom.diag.sat.constraint.AtLeastOneEvent;
import edu.supercom.diag.sat.constraint.CommunicationConstraints;
import edu.supercom.diag.sat.constraint.ConjunctionConstraint;
import edu.supercom.diag.sat.constraint.EffectOfRule;
import edu.supercom.diag.sat.constraint.EventImpliesRule;
import edu.supercom.diag.sat.constraint.FrameAxiom;
import edu.supercom.diag.sat.constraint.Loop;
import edu.supercom.diag.sat.constraint.NoEvent;
import edu.supercom.diag.sat.constraint.OneStateAtATime;
import edu.supercom.diag.sat.constraint.OneTransitionPerComponent;
import edu.supercom.diag.sat.constraint.RuleGeneratesEvents;
import edu.supercom.diag.sat.constraint.RuleImpliesPrecondition;
import edu.supercom.diag.sat.constraint.SameEvents;
import edu.supercom.diag.sat.constraint.StateSet;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.util.Main;
import edu.supercom.util.Options;
import edu.supercom.util.sat.CNF;
import edu.supercom.util.sat.Clause;
import edu.supercom.util.sat.ClausePruner;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.ImplyStream;
import edu.supercom.util.sat.PrintClauseStream;
import edu.supercom.util.sat.VariableLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ND {
    public static Set<ComponentEvent> readFaults(BufferedReader bufferedReader, Topology topology) {
        HashSet<ComponentEvent> hashSet = new HashSet<ComponentEvent>();
        Main.readFaults(bufferedReader, topology, hashSet);
        return hashSet;
    }

    public static void nonDiagty(ClauseStream clauseStream, int n, CompositeSystem compositeSystem, Collection<Component> collection, Collection<ComponentEvent> collection2, PrintStream printStream) {
        VariableLoader variableLoader = new VariableLoader();
        CompositeSystemAssigner2 compositeSystemAssigner2 = new CompositeSystemAssigner2(compositeSystem, variableLoader);
        compositeSystemAssigner2.allocate(0, n);
        CompositeSystemAssigner2 compositeSystemAssigner22 = new CompositeSystemAssigner2(compositeSystem, variableLoader);
        compositeSystemAssigner22.allocate(0, n);
        if (printStream != null) {
            printStream.println("First system");
            compositeSystemAssigner2.print(printStream);
            printStream.println("Second system");
            compositeSystemAssigner22.print(printStream);
        }
        Topology topology = compositeSystem.getInitialTopology();
        Subsystem subsystem = topology.activeSubsystem();
        TimeInterval timeInterval = new TimeInterval(0, n);
        Object object = new ConjunctionConstraint();
        ((ConjunctionConstraint)object).add(new OneStateAtATime(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new RuleImpliesPrecondition(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new EffectOfRule(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new FrameAxiom(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new RuleGeneratesEvents(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new EventImpliesRule(subsystem, timeInterval));
        ((ConjunctionConstraint)object).add(new CommunicationConstraints(topology, timeInterval));
        ((ConjunctionConstraint)object).add(new OneTransitionPerComponent(subsystem, timeInterval));
        ((ConjunctionConstraint)object).apply(compositeSystemAssigner2, clauseStream);
        ((ConjunctionConstraint)object).apply(compositeSystemAssigner22, clauseStream);
        object = AbstractTopology.observableEvents(compositeSystem.getInitialTopology(), collection);
        SameEvents sameEvents = new SameEvents((Collection<ComponentEvent>)object, compositeSystemAssigner2, timeInterval);
        sameEvents.apply(compositeSystemAssigner22, clauseStream);
        object = new NoEvent(collection2, timeInterval);
        object.apply(compositeSystemAssigner2, clauseStream);
        object = new AtLeastOneEvent(collection2, timeInterval);
        object.apply(compositeSystemAssigner22, clauseStream);
        object = new StateSet(compositeSystem.getInitialConfiguration().getSubsystemState(), new TimeInterval(0));
        object.apply(compositeSystemAssigner2, clauseStream);
        object.apply(compositeSystemAssigner22, clauseStream);
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            Object object2;
            Loop loop = new Loop(subsystem, new TimeInterval(i, n));
            ConjunctionConstraint conjunctionConstraint = new ConjunctionConstraint();
            for (Component component : collection) {
                object2 = new HashSet<ComponentEvent>();
                for (Port port : topology.observablePorts(component)) {
                    for (Event event : port.events()) {
                        object2.add(component.getComponentEvent(event));
                    }
                }
                conjunctionConstraint.add(new AtLeastOneEvent((Collection<ComponentEvent>)object2, timeInterval));
            }
            edu.supercom.diag.sat.sem.Loop loop2 = new edu.supercom.diag.sat.sem.Loop(i, n);
            int n2 = variableLoader.allocate(1);
            if (printStream != null) {
                printStream.println(n2 + "\t" + loop2);
            }
            object[i] = n2;
            object2 = new ImplyStream(clauseStream, n2);
            loop.apply(compositeSystemAssigner2, (ClauseStream)object2);
            loop.apply(compositeSystemAssigner22, (ClauseStream)object2);
            conjunctionConstraint.apply(compositeSystemAssigner2, (ClauseStream)object2);
        }
        clauseStream.put(new Clause((int[])object));
    }

    public static void printUsage(PrintStream printStream) {
        printStream.println("usage: java edu.supercom.diag.sat.NonDiagty [option]*");
        printStream.println("Options include: ");
        printStream.println("\tsystem=???.csdl: name of the file that contains the system description.");
        printStream.println("\tout=???.cnf:     name of the file where the clauses must be stored.");
        printStream.println("\tn=???:           length of the counter example we are searching for.");
        printStream.println("\tcomps=???:       (optional) name of the file that contains the restricted list of components where are interested in. The format of the file is a component name per line.");
        printStream.println("\tfaults=???:      name of the file that contains the list of fault events.  The format of this file is an event by line described by: <code>compName portname messName</code>.");
        printStream.println("\tdesc=???:        (optional) file that contains a description of the variable");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Options options = new Options(stringArray);
        CompositeSystem compositeSystem = Main.readSystem(options, System.err);
        String string = options.getOption("out");
        if (string == null) {
            System.err.println("Option ``out'' unassigned.");
            ND.printUsage(System.err);
            System.exit(1);
        }
        Object object5 = options.getOption("n");
        int n = 0;
        try {
            n = Integer.parseInt((String)object5);
        }
        catch (Exception exception) {
            System.err.println("Error with option ``n''.");
            ND.printUsage(System.err);
            System.exit(1);
        }
        int n2 = n;
        object5 = new HashSet();
        try {
            object4 = options.getOption("comps");
            if (object4 == null) {
                object5.addAll(compositeSystem.getInitialTopology().activeSubsystem().getComponents());
            } else {
                object3 = new BufferedReader(new FileReader((String)object4));
                while (((BufferedReader)object3).ready()) {
                    object2 = ((BufferedReader)object3).readLine();
                    object = compositeSystem.getComponent((String)object2);
                    if (object == null || !compositeSystem.getInitialTopology().isActive((Component)object)) {
                        System.err.println("Impossible to find active component " + (String)object2);
                        ND.printUsage(System.err);
                        System.exit(1);
                    }
                    object5.add(object);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            ND.printUsage(System.err);
            System.exit(1);
        }
        object4 = new HashSet();
        try {
            object3 = options.getOption("faults");
            if (object3 == null) {
                System.err.println("Option ``faults'' unassigned.");
                ND.printUsage(System.err);
                System.exit(1);
            }
            object2 = new BufferedReader(new FileReader((String)object3));
            object4.addAll(ND.readFaults((BufferedReader)object2, compositeSystem.getInitialTopology()));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            ND.printUsage(System.err);
            System.exit(1);
        }
        object2 = null;
        try {
            object2 = File.createTempFile("cnf", "tmp");
        }
        catch (IOException iOException) {
            System.err.println("Could not create a TMP file");
            System.exit(1);
        }
        object3 = object2;
        ((File)object3).deleteOnExit();
        Object object6 = null;
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream((File)object3));
            object6 = new ClausePruner(new PrintClauseStream(printStream));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        object2 = object6;
        object = printStream;
        printStream = null;
        String string2 = options.getOption("desc");
        if (string2 != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(stringArray[5]));
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                ND.printUsage(System.err);
                System.exit(1);
            }
        }
        object6 = printStream;
        ND.nonDiagty((ClauseStream)object2, n2, compositeSystem, (Collection<Component>)object5, (Collection<ComponentEvent>)object4, (PrintStream)object6);
        ((PrintStream)object).close();
        try {
            CNF.finalizeCNF("If satisfiable, the system is not diagnosable", ((File)object3).getCanonicalPath(), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
            ND.printUsage(System.err);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            ND.printUsage(System.err);
        }
    }
}

