/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.Connection;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Message;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Topology;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.EventOccurrence;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;

public class CommunicationConstraints
extends BoundedPathConstraint
implements PathConstraint {
    private final Topology _top;
    private final Subsystem _comps;

    public CommunicationConstraints(Topology topology, Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._top = topology;
        this._comps = subsystem;
    }

    public CommunicationConstraints(Topology topology, TimeInterval timeInterval) {
        this(topology, topology.activeSubsystem(), timeInterval);
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Connection connection : this._top.connections()) {
            int n;
            Event event;
            Component component;
            Component component2 = connection.getSourceComponent();
            if (!this._comps.containsComponent(component2) || !this._comps.containsComponent(component = connection.getTargetComponent())) continue;
            Port port = connection.getSourcePort();
            Port port2 = connection.getTargetPort();
            for (Message message : port.messages()) {
                event = port.getEvent(message);
                Event event2 = port2.getEvent(message);
                for (n = this.begin(); n < this.end(); ++n) {
                    int n2 = variableAssigner.getVariable(new EventOccurrence(component2, event, n));
                    if (event2 == null) {
                        if (n2 == 0) continue;
                        clauseStream.put(-n2);
                        continue;
                    }
                    int n3 = variableAssigner.getVariable(new EventOccurrence(component, event2, n));
                    if (n2 == 0 && n3 == 0) continue;
                    if (n2 == 0) {
                        clauseStream.put(-n3);
                        continue;
                    }
                    if (n3 == 0) {
                        clauseStream.put(-n2);
                        continue;
                    }
                    clauseStream.put(-n2, n3);
                    clauseStream.put(n2, -n3);
                }
            }
            for (Message message : port2.messages()) {
                if (port.mayOccur(message)) continue;
                event = port2.getEvent(message);
                for (int i = this.begin(); i < this.end(); ++i) {
                    n = variableAssigner.getVariable(new EventOccurrence(component, event, i));
                    if (n == 0) continue;
                    clauseStream.put(-n);
                }
            }
        }
    }
}

