/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;
import java.util.Map;

public class EffectOfRule
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public EffectOfRule(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Rule rule : componentType.rules()) {
                Map<Variable, Value> map = rule.getEffect().assignments().values().iterator().next();
                for (int i = this.begin(); i < this.end(); ++i) {
                    RuleTrigger ruleTrigger = new RuleTrigger(component, rule, i);
                    int n = -variableAssigner.getVariable(ruleTrigger);
                    if (n == 0) continue;
                    for (Variable variable : map.keySet()) {
                        Value value;
                        TimedAssignement timedAssignement = new TimedAssignement(component, variable.getAssignement(value = map.get(variable)), i + 1);
                        int n2 = variableAssigner.getVariable(timedAssignement);
                        if (n2 == 0) {
                            clauseStream.put(n);
                            continue;
                        }
                        clauseStream.put(n, n2);
                    }
                }
            }
        }
    }
}

