/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.EventOccurrence;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;
import java.util.ArrayList;
import java.util.HashSet;

public class EventImpliesRule
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public EventImpliesRule(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Event event : componentType.events()) {
                HashSet<Rule> hashSet = new HashSet<Rule>(componentType.generatingRules(event));
                for (int i = this.begin(); i < this.end(); ++i) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int n = variableAssigner.getVariable(new EventOccurrence(component, event, i));
                    if (n == 0) continue;
                    arrayList.add(-n);
                    for (Rule rule : hashSet) {
                        int n2 = variableAssigner.getVariable(new RuleTrigger(component, rule, i));
                        if (n2 == 0) continue;
                        arrayList.add(n2);
                    }
                    clauseStream.put(arrayList);
                }
            }
        }
    }
}

