/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.UnmodifiableCollection;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;
import java.util.ArrayList;

public class FrameAxiom
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public FrameAxiom(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Variable variable : componentType.variables()) {
                for (Value value : variable.getDomain().values()) {
                    Assignment assignment = variable.getAssignement(value);
                    UnmodifiableCollection<Rule> unmodifiableCollection = componentType.ruleAffecting(assignment);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = this.begin(); i < this.end(); ++i) {
                        arrayList.clear();
                        int n = variableAssigner.getVariable(new TimedAssignement(component, assignment, i + 1));
                        if (n == 0) continue;
                        arrayList.add(-n);
                        n = variableAssigner.getVariable(new TimedAssignement(component, assignment, i));
                        if (n != 0) {
                            arrayList.add(n);
                        }
                        for (Rule rule : unmodifiableCollection) {
                            int n2 = variableAssigner.getVariable(new RuleTrigger(component, rule, i));
                            if (n2 == 0) continue;
                            arrayList.add(n2);
                        }
                        clauseStream.put(arrayList);
                    }
                }
            }
        }
    }
}

