/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;

public class Loop
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public Loop(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Variable variable : componentType.variables()) {
                for (Value value : variable.getDomain().values()) {
                    Assignment assignment = variable.getAssignement(value);
                    TimedAssignement timedAssignement = new TimedAssignement(component, assignment, this.begin());
                    TimedAssignement timedAssignement2 = new TimedAssignement(component, assignment, this.end());
                    int n = variableAssigner.getVariable(timedAssignement);
                    int n2 = variableAssigner.getVariable(timedAssignement2);
                    if (n == 0 && n2 == 0) continue;
                    if (n == 0) {
                        clauseStream.put(-n2);
                        continue;
                    }
                    if (n2 == 0) {
                        clauseStream.put(-n);
                        continue;
                    }
                    clauseStream.put(-n, n2);
                }
            }
        }
    }
}

