/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Domain;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.Value;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;
import java.util.ArrayList;

public class OneStateAtATime
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public OneStateAtATime(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Variable variable : componentType.variables()) {
                Domain domain = variable.getDomain();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = this.begin(); i <= this.end(); ++i) {
                    arrayList.clear();
                    for (Value value : domain) {
                        TimedAssignement timedAssignement = new TimedAssignement(component, variable.getAssignement(value), i);
                        int n = variableAssigner.getVariable(timedAssignement);
                        if (n == 0) continue;
                        arrayList.add(n);
                    }
                    if (arrayList.isEmpty()) {
                        System.err.println("Empty list.");
                    }
                    clauseStream.put(arrayList);
                    int n = arrayList.size();
                    for (int j = 0; j < n; ++j) {
                        for (int k = j + 1; k < n; ++k) {
                            clauseStream.put(-((Integer)arrayList.get(j)).intValue(), -((Integer)arrayList.get(k)).intValue());
                        }
                    }
                }
            }
        }
    }
}

