/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Port;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.EventOccurrence;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.util.UnmodifiableSet;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;
import java.util.HashSet;

public class OneTransitionPerComponent
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public OneTransitionPerComponent(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            int n;
            int n2;
            ComponentType componentType = component.getType();
            HashSet<Event> hashSet = new HashSet<Event>();
            for (Port port : componentType.inputPorts()) {
                hashSet.addAll(port.events());
            }
            Event[] eventArray = new Event[hashSet.size()];
            hashSet.toArray(eventArray);
            for (n2 = this.begin(); n2 < this.end(); ++n2) {
                for (int i = 0; i < eventArray.length; ++i) {
                    int n3 = variableAssigner.getVariable(new EventOccurrence(component, eventArray[i], n2));
                    if (n3 == 0) continue;
                    for (int j = i + 1; j < eventArray.length; ++j) {
                        n = variableAssigner.getVariable(new EventOccurrence(component, eventArray[j], n2));
                        if (n == 0) continue;
                        clauseStream.put(-n3, -n);
                    }
                }
            }
            for (n2 = 0; n2 < eventArray.length; ++n2) {
                Event event = eventArray[n2];
                UnmodifiableSet<Rule> unmodifiableSet = componentType.generatingRules(event);
                if (unmodifiableSet.size() < 2) continue;
                Rule[] ruleArray = new Rule[unmodifiableSet.size()];
                unmodifiableSet.toArray(ruleArray);
                for (n = this.begin(); n < this.end(); ++n) {
                    for (int i = 0; i < ruleArray.length; ++i) {
                        Rule rule = ruleArray[i];
                        int n4 = variableAssigner.getVariable(new RuleTrigger(component, rule, n));
                        if (n4 == 0) continue;
                        for (int j = i + 1; j < ruleArray.length; ++j) {
                            Rule rule2 = ruleArray[j];
                            int n5 = variableAssigner.getVariable(new RuleTrigger(component, rule2, n));
                            if (n5 == 0) continue;
                            clauseStream.put(-n4, -n5);
                        }
                    }
                }
            }
        }
    }
}

