/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Event;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.EventOccurrence;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;

public class RuleGeneratesEvents
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public RuleGeneratesEvents(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Rule rule : componentType.rules()) {
                Event event = rule.getTriggeringEvent();
                this.ruleImpliesEvent(variableAssigner, clauseStream, component, rule, event);
                for (Event event2 : rule.outputEvents()) {
                    this.ruleImpliesEvent(variableAssigner, clauseStream, component, rule, event2);
                }
            }
        }
    }

    private void ruleImpliesEvent(VariableAssigner variableAssigner, ClauseStream clauseStream, Component component, Rule rule, Event event) {
        if (event.containsOption("optional")) {
            return;
        }
        if (event.getPort().containsOption("optional")) {
            return;
        }
        for (int i = this.begin(); i < this.end(); ++i) {
            EventOccurrence eventOccurrence;
            int n;
            RuleTrigger ruleTrigger = new RuleTrigger(component, rule, i);
            int n2 = variableAssigner.getVariable(ruleTrigger);
            if (n2 == 0 || (n = variableAssigner.getVariable(eventOccurrence = new EventOccurrence(component, event, i))) == 0) continue;
            clauseStream.put(-n2, n);
        }
    }
}

