/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.Rule;
import edu.supercom.csdl.Subsystem;
import edu.supercom.csdl.TypeStateCondition;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.RuleTrigger;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.sat.Clause;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;

public class RuleImpliesPrecondition
extends BoundedPathConstraint
implements PathConstraint {
    private final Subsystem _sub;

    public RuleImpliesPrecondition(Subsystem subsystem, TimeInterval timeInterval) {
        super(timeInterval);
        this._sub = subsystem;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._sub) {
            ComponentType componentType = component.getType();
            for (Rule rule : componentType.rules()) {
                int n;
                TypeStateCondition typeStateCondition = rule.getPrecondition();
                TypeStateCondition typeStateCondition2 = typeStateCondition.cnf();
                if (typeStateCondition2.isConstant()) {
                    if (typeStateCondition2.getConstant()) continue;
                    for (n = this.begin(); n < this.end(); ++n) {
                        int n2 = variableAssigner.getVariable(new RuleTrigger(component, rule, n));
                        clauseStream.put(-n2);
                    }
                    continue;
                }
                do {
                    TypeStateCondition typeStateCondition3;
                    if ((n = typeStateCondition2.isAnd()) != 0) {
                        typeStateCondition3 = typeStateCondition2.getAndLeftPart();
                        typeStateCondition2 = typeStateCondition2.getAndRightPart();
                    } else {
                        typeStateCondition3 = typeStateCondition2;
                    }
                    this.apply(variableAssigner, clauseStream, rule, typeStateCondition3, component);
                } while (n != 0);
            }
        }
    }

    private void apply(VariableAssigner variableAssigner, ClauseStream clauseStream, Rule rule, TypeStateCondition typeStateCondition, Component component) {
        for (int i = this.begin(); i < this.end(); ++i) {
            boolean bl;
            TypeStateCondition typeStateCondition2 = typeStateCondition;
            RuleTrigger ruleTrigger = new RuleTrigger(component, rule, i);
            int n = variableAssigner.getVariable(ruleTrigger);
            if (n == 0) continue;
            Clause clause = new Clause(-n);
            do {
                Assignment assignment;
                TimedAssignement timedAssignement;
                int n2;
                TypeStateCondition typeStateCondition3;
                if (bl = typeStateCondition2.isOr()) {
                    typeStateCondition3 = typeStateCondition2.getOrLeftPart();
                    typeStateCondition2 = typeStateCondition2.getOrRightPart();
                } else {
                    typeStateCondition3 = typeStateCondition2;
                }
                boolean bl2 = typeStateCondition3.isNegation();
                if (bl2) {
                    typeStateCondition3 = typeStateCondition3.getNegation();
                }
                if ((n2 = variableAssigner.getVariable(timedAssignement = new TimedAssignement(component, assignment = typeStateCondition3.getAssignement(), i))) == 0) continue;
                if (bl2) {
                    n2 = -n2;
                }
                clause = new Clause(clause, n2);
            } while (bl);
            clauseStream.put(clause);
        }
    }
}

