/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.diag.sat.constraint;

import edu.supercom.csdl.Assignment;
import edu.supercom.csdl.Component;
import edu.supercom.csdl.ComponentState;
import edu.supercom.csdl.ComponentType;
import edu.supercom.csdl.SubsystemState;
import edu.supercom.csdl.TypeState;
import edu.supercom.csdl.Variable;
import edu.supercom.diag.sat.PathConstraint;
import edu.supercom.diag.sat.constraint.BoundedPathConstraint;
import edu.supercom.diag.sat.constraint.TimeInterval;
import edu.supercom.diag.sat.sem.TimedAssignement;
import edu.supercom.util.sat.Clause;
import edu.supercom.util.sat.ClauseStream;
import edu.supercom.util.sat.VariableAssigner;

public class StateSet
extends BoundedPathConstraint
implements PathConstraint {
    private final SubsystemState _state;

    public StateSet(SubsystemState subsystemState, TimeInterval timeInterval) {
        super(timeInterval);
        this._state = subsystemState;
    }

    @Override
    public void apply(VariableAssigner variableAssigner, ClauseStream clauseStream) {
        for (Component component : this._state.getSubsystem()) {
            ComponentState componentState = this._state.getComponentState(component);
            TypeState typeState = componentState.getTypeState();
            ComponentType componentType = component.getType();
            for (Variable variable : componentType.variables()) {
                Assignment assignment = typeState.getAssignement(variable);
                if (assignment == null) continue;
                for (int i = this.begin(); i <= this.end(); ++i) {
                    int n = variableAssigner.getVariable(new TimedAssignement(component, assignment, i));
                    if (n == 0) {
                        clauseStream.put(new Clause());
                        continue;
                    }
                    clauseStream.put(n);
                }
            }
        }
    }
}

