/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.util;

import edu.supercom.util.EquivalenceClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Equivalence<E>
implements Set<E> {
    private Set<EquivalenceClass<E>> _partition = new HashSet<EquivalenceClass<E>>();
    private Map<E, EquivalenceClass<E>> _objToSet = new HashMap<E, EquivalenceClass<E>>();

    @Override
    public boolean add(E e) {
        if (this._objToSet.containsKey(e)) {
            return false;
        }
        EquivalenceClass<E> equivalenceClass = new EquivalenceClass<E>(e);
        this._partition.add(equivalenceClass);
        this._objToSet.put(e, equivalenceClass);
        return true;
    }

    public void equivalent(E e, E e2) {
        EquivalenceClass<E> equivalenceClass;
        EquivalenceClass<E> equivalenceClass2;
        EquivalenceClass<E> equivalenceClass3 = this._objToSet.get(e);
        if (equivalenceClass3 == null) {
            throw new NoSuchElementException("This object is not in the set " + e);
        }
        EquivalenceClass<E> equivalenceClass4 = this._objToSet.get(e2);
        if (equivalenceClass4 == null) {
            throw new NoSuchElementException("This object is not in the set " + e2);
        }
        if (equivalenceClass3 == equivalenceClass4) {
            return;
        }
        if (equivalenceClass3.size() > equivalenceClass4.size()) {
            equivalenceClass2 = equivalenceClass3;
            equivalenceClass = equivalenceClass4;
        } else {
            equivalenceClass2 = equivalenceClass4;
            equivalenceClass = equivalenceClass3;
        }
        this._partition.remove(equivalenceClass);
        equivalenceClass2.addAll(equivalenceClass.iterator());
        for (E e3 : equivalenceClass) {
            this._objToSet.put(e3, equivalenceClass2);
        }
        equivalenceClass.clear();
    }

    public void merge(E e, E e2) {
        EquivalenceClass<E> equivalenceClass = this._objToSet.get(e);
        EquivalenceClass<E> equivalenceClass2 = this._objToSet.get(e2);
        if (equivalenceClass == null && equivalenceClass2 == null) {
            return;
        }
        if (equivalenceClass == null || equivalenceClass2 == null) {
            EquivalenceClass<E> equivalenceClass3 = equivalenceClass == null ? equivalenceClass2 : equivalenceClass;
            this.removeAll(new HashSet<E>(equivalenceClass3.toSet()));
            return;
        }
        this.equivalent(e, e2);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this._objToSet.keySet()).iterator();
    }

    public Iterator<EquivalenceClass<E>> classIterator() {
        return Collections.unmodifiableCollection(this._partition).iterator();
    }

    public Set<EquivalenceClass<E>> classes() {
        return Collections.unmodifiableSet(this._partition);
    }

    public EquivalenceClass<E> equivalenceClass(E e) {
        return this._objToSet.get(e);
    }

    @Override
    public boolean remove(Object object) {
        EquivalenceClass<E> equivalenceClass = this._objToSet.get(object);
        if (equivalenceClass == null) {
            return false;
        }
        equivalenceClass.remove(object);
        if (equivalenceClass.isEmpty()) {
            this._partition.remove(equivalenceClass);
        }
        this._objToSet.remove(object);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            boolean bl2 = this.add(e);
            bl = bl || bl2;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            boolean bl2 = this.remove(obj);
            bl = bl || bl2;
        }
        return bl;
    }

    @Override
    public boolean removeAll(EquivalenceClass<E> equivalenceClass) {
        if (equivalenceClass == null) {
            return false;
        }
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : equivalenceClass) {
            hashSet.add(e);
        }
        return this.removeAll(hashSet);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this._partition.clear();
        this._objToSet.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this._objToSet.containsKey(object);
    }

    @Override
    public int hashCode() {
        int n = 19;
        for (E e : this) {
            n += e.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Equivalence) {
            Equivalence equivalence = (Equivalence)object;
            return this._objToSet.equals(equivalence);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._objToSet.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : this) {
            if (collection.contains(e)) continue;
            arrayList.add(e);
        }
        return this.removeAll(arrayList);
    }

    @Override
    public int size() {
        return this._objToSet.size();
    }

    @Override
    public Object[] toArray() {
        return this._objToSet.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        return this._objToSet.keySet().toArray(EArray);
    }

    public String toString() {
        return this._partition.toString();
    }
}

