/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.util;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import edu.supercom.csdl.ComponentEvent;
import edu.supercom.csdl.CompositeSystem;
import edu.supercom.csdl.Topology;
import edu.supercom.util.Options;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    public static final Pattern OPTION_PATTERN = Pattern.compile("^(.+)=(.*)$");
    public static final Pattern OPTION_COMMENTED = Pattern.compile("^//.*");

    public static Map<String, String> readOptions(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Matcher matcher = OPTION_PATTERN.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                if (string2.equals("optionFile")) {
                    File file = new File(string3);
                    File[] fileArray = new File[]{};
                    Main.readOptions(hashMap, file, fileArray);
                    continue;
                }
                hashMap.put(string2, string3);
                continue;
            }
            hashMap.put(string, string);
        }
        return hashMap;
    }

    private static void readOptions(Map<String, String> map, File file, File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].equals(file)) continue;
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null || string.equals("") || OPTION_COMMENTED.matcher(string).matches()) continue;
                Matcher matcher = OPTION_PATTERN.matcher(string);
                if (matcher.matches()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    if (string2.equals("optionFile")) {
                        File file2 = new File(file.getParent(), string3);
                        File[] fileArray2 = new File[fileArray.length + 1];
                        for (int i = 0; i < fileArray.length; ++i) {
                            fileArray2[i] = fileArray[i];
                        }
                        fileArray2[fileArray.length] = file;
                        Main.readOptions(map, file2, fileArray2);
                        continue;
                    }
                    map.put(string2, string3);
                    continue;
                }
                map.put(string, string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Warning: Error reading file: ");
            System.err.print("\t");
            for (int i = 0; i < fileArray.length; ++i) {
                System.err.print("'" + fileArray[i] + "' -> ");
            }
            System.err.println("'" + file + "'");
            System.err.println("\tException: " + iOException.getMessage());
        }
    }

    public static String getOption(Map<String, String> map, boolean bl, boolean bl2, String ... stringArray) {
        for (String string : stringArray) {
            String string2 = map.get(string);
            if (string2 == null) continue;
            return string2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Option not found.  Specify one of the following options: ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                string = stringArray[i];
                stringBuffer.append("'").append(string).append("'");
                if (i == n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(".");
            System.err.println(stringBuffer);
        }
        if (bl2) {
            System.exit(1);
        }
        return null;
    }

    public static PrintStream openPrintStream(String string, PrintStream printStream) {
        if (string == null) {
            return printStream;
        }
        try {
            return new PrintStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File openTemporaryFile(String string, String string2, File file) {
        try {
            File file2 = File.createTempFile(string, string2, file);
            file2.deleteOnExit();
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static CompositeSystem readSystem(Map<String, String> map, PrintStream printStream) {
        CompositeSystem compositeSystem = null;
        try {
            String string = Main.getOption(map, true, true, "system", "model");
            compositeSystem = CompositeSystem.load(string);
        }
        catch (IOException iOException) {
            printStream.println(iOException);
            System.exit(0);
        }
        catch (RecognitionException recognitionException) {
            recognitionException.printStackTrace();
            System.exit(0);
        }
        catch (TokenStreamException tokenStreamException) {
            tokenStreamException.printStackTrace();
            System.exit(0);
        }
        return compositeSystem;
    }

    public static CompositeSystem readSystem(Options options, PrintStream printStream) {
        CompositeSystem compositeSystem = null;
        try {
            String string = options.getOption(true, true, "system", "model");
            compositeSystem = CompositeSystem.load(string);
        }
        catch (IOException iOException) {
            printStream.println(iOException);
            System.exit(0);
        }
        catch (RecognitionException recognitionException) {
            recognitionException.printStackTrace();
            System.exit(0);
        }
        catch (TokenStreamException tokenStreamException) {
            tokenStreamException.printStackTrace();
            System.exit(0);
        }
        return compositeSystem;
    }

    public static Collection<ComponentEvent> readFaults(Map<String, String> map, CompositeSystem compositeSystem, PrintStream printStream) {
        ArrayList<ComponentEvent> arrayList = new ArrayList<ComponentEvent>();
        try {
            Main.readFaults(new BufferedReader(new FileReader(map.get("faults"))), compositeSystem.getInitialTopology(), arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            printStream.println("Unspecified option: faults");
            System.exit(1);
        }
        return arrayList;
    }

    public static Collection<ComponentEvent> readFaults(Options options, CompositeSystem compositeSystem, PrintStream printStream) {
        ArrayList<ComponentEvent> arrayList = new ArrayList<ComponentEvent>();
        try {
            Main.readFaults(new BufferedReader(new FileReader(options.getOption(true, true, "faults"))), compositeSystem.getInitialTopology(), arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            printStream.println("Unspecified option: faults");
            System.exit(1);
        }
        return arrayList;
    }

    public static void readFaults(BufferedReader bufferedReader, Topology topology, Collection<ComponentEvent> collection) {
        try {
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                ComponentEvent componentEvent = ComponentEvent.read(string, topology, " ");
                if (componentEvent == null) {
                    System.err.println("Unknown event " + string);
                    System.err.println("Ignored");
                    continue;
                }
                collection.add(componentEvent);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

