/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Options {
    public static final Pattern OPTION_PATTERN = Pattern.compile("^(.+)=(.*)$");
    public static final Pattern OPTION_COMMENTED = Pattern.compile("^//.*");
    public static final String OPTION_DIRECTORY = "#PATH#";
    private final Map<String, String> _pairs = new HashMap<String, String>();
    private final Map<String, Collection<String>> _options = new HashMap<String, Collection<String>>();

    public Options() {
    }

    public Options(String[] stringArray) {
        this();
        this.computeOptions(stringArray);
    }

    private void computeOptions(final String[] stringArray) {
        Iterator<String> iterator = new Iterator<String>(){
            private int _i = 0;

            @Override
            public boolean hasNext() {
                return this._i < stringArray.length;
            }

            @Override
            public String next() {
                String string = stringArray[this._i];
                ++this._i;
                return string;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        arrayDeque.add("# Arguments");
        try {
            this.computeOptions(iterator, new File("./"), arrayDeque);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            StringBuffer stringBuffer = new StringBuffer();
            while (!arrayDeque.isEmpty()) {
                String string = (String)arrayDeque.pop();
                stringBuffer.append("From ").append(string).append("\n");
            }
            System.err.println(stringBuffer);
        }
    }

    private void computeOptions(Iterator<String> iterator, File file, Deque<String> deque) throws IOException {
        while (iterator.hasNext()) {
            Matcher matcher;
            String string = iterator.next();
            if (OPTION_COMMENTED.matcher(string).matches() || !(matcher = OPTION_PATTERN.matcher(string)).matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2.equals("optionFile")) {
                File file2 = string3.startsWith("/") ? new File(string3) : new File(file, string3);
                if (deque.contains(file2.getAbsolutePath())) continue;
                deque.add(file2.getAbsolutePath());
                final BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                Iterator<String> iterator2 = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return bufferedReader.ready();
                        }
                        catch (IOException iOException) {
                            return true;
                        }
                    }

                    @Override
                    public String next() {
                        try {
                            return bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new IllegalStateException("Problem reading.");
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                };
                this.computeOptions(iterator2, file2.getParentFile(), deque);
                bufferedReader.close();
                continue;
            }
            string3 = string3.replaceAll(OPTION_DIRECTORY, file.getAbsolutePath());
            if (string2.startsWith("@")) {
                this.addOption(string2, string3);
                continue;
            }
            this.createOption(string2, string3);
        }
        deque.pop();
    }

    public String getOption(String string) {
        return this._pairs.get(string);
    }

    public String getOption(boolean bl, boolean bl2, String ... stringArray) {
        for (String string : stringArray) {
            String string2 = this.getOption(string);
            if (string2 == null) continue;
            return string2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Option not found.  Specify one of the following options: ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                string = stringArray[i];
                stringBuffer.append("'").append(string).append("'");
                if (i == n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(".");
            System.err.println(stringBuffer);
        }
        if (bl2) {
            System.exit(1);
        }
        return null;
    }

    public Collection<String> getOptions(String string) {
        Collection<String> collection = this._options.get(string);
        if (collection != null) {
            return Collections.unmodifiableCollection(collection);
        }
        collection = Collections.emptyList();
        return collection;
    }

    public void createOption(String string, String string2) {
        this._pairs.put(string, string2);
    }

    public void addOption(String string, String string2) {
        Collection<String> collection = this._options.get(string);
        if (collection == null) {
            collection = new ArrayList<String>();
            this._options.put(string, collection);
        }
        Collection<String> collection2 = collection;
        collection2.add(string2);
    }

    public String toString() {
        return this._options.toString() + "\n" + this._pairs.toString();
    }
}

