/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.util;

import java.util.Iterator;
import java.util.List;

public class Pair<C1, C2>
implements Comparable<Pair<C1, C2>> {
    private C1 _a;
    private C2 _b;

    public Pair(C1 C1, C2 C2) {
        this._a = C1;
        this._b = C2;
    }

    public static <C1, C2> Pair<C1, C2> newPair(C1 C1, C2 C2) {
        return new Pair<C1, C2>(C1, C2);
    }

    public int hashCode() {
        return Pair.hashCode(this._a, this._b);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        if (this._a != pair._a) {
            if (this._a == null) {
                return false;
            }
            if (pair._a == null) {
                return false;
            }
            if (!this._a.equals(pair._a)) {
                return false;
            }
        }
        if (this._b != pair._b) {
            if (this._b == null) {
                return false;
            }
            if (pair._b == null) {
                return false;
            }
            if (!this._b.equals(pair._b)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Pair<C1, C2> pair) {
        int n = ((Comparable)this._a).compareTo(pair._a);
        if (n == 0) {
            n = ((Comparable)this._b).compareTo(pair._b);
        }
        return n;
    }

    public C1 first() {
        return this._a;
    }

    public C2 second() {
        return this._b;
    }

    public void setFirst(C1 C1) {
        this._a = C1;
    }

    public void setSecond(C2 C2) {
        this._b = C2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        if (this._a != null) {
            stringBuilder.append(this._a.toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(",");
        if (this._b != null) {
            stringBuilder.append(this._b.toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public static int hashCode(Object object, Object object2) {
        int n = object == null ? 0 : object.hashCode();
        int n2 = object2 == null ? 0 : object2.hashCode();
        int n3 = n + n2;
        return (n3 + (n3 + 1) >> 1) + n;
    }

    public static <O> Iterable<Pair<O, O>> allPairs(final List<? extends O> list) {
        return new Iterable<Pair<O, O>>(){
            final int size;
            {
                this.size = list.size();
            }

            @Override
            public Iterator<Pair<O, O>> iterator() {
                return new AllPairIterator();
            }

            class AllPairIterator
            implements Iterator<Pair<O, O>> {
                int i = 0;
                int j = 1;

                AllPairIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.i < size - 1;
                }

                @Override
                public Pair<O, O> next() {
                    Pair pair = new Pair(list.get(this.i), list.get(this.j));
                    ++this.j;
                    if (this.j >= size) {
                        ++this.i;
                        this.j = this.i + 1;
                    }
                    return pair;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }
}

