/*
 * Decompiled with CFR 0.152.
 */
package edu.supercom.util;

import edu.supercom.util.UMCM;
import edu.supercom.util.UnmodifiableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UnmodifiableMapConstructor<K, V>
implements Map<K, V> {
    private final UnmodifiableMap<K, V> _result;
    private boolean _flag = false;
    private final Map<K, V> _map;

    public UnmodifiableMapConstructor() {
        this(Collections.emptyMap());
    }

    public UnmodifiableMapConstructor(Map<? extends K, ? extends V> map) {
        this._map = new HashMap<K, V>(map);
        this._result = new UMCM<K, V>(this._map);
    }

    public UnmodifiableMap<K, V> getMap() {
        this._flag = true;
        return this._result;
    }

    public boolean addMapping(K k, V v) {
        if (this._flag) {
            throw new IllegalStateException("Cannot add a mapping: unmodifiable map already accessed,");
        }
        V v2 = this._map.put(k, v);
        if (v2 == null) {
            return v != null;
        }
        return !v2.equals(v);
    }

    public boolean removeMapping(K k) {
        if (this._flag) {
            throw new IllegalStateException("Cannot add a mapping: unmodifiable map already accessed,");
        }
        if (!this._map.containsKey(k)) {
            return false;
        }
        this._map.remove(k);
        return true;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() != 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this._map.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this._map.get(object);
    }

    @Override
    public V put(K k, V v) {
        if (this._flag) {
            throw new IllegalStateException("Cannot add a mapping: unmodifiable map already accessed,");
        }
        return this._map.put(k, v);
    }

    @Override
    public V remove(Object object) {
        if (this._flag) {
            throw new IllegalStateException("Cannot remove a mapping: unmodifiable map already accessed,");
        }
        return this._map.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this._flag) {
            throw new IllegalStateException("Cannot add a mapping: unmodifiable map already accessed,");
        }
        this._map.putAll(map);
    }

    @Override
    public void clear() {
        if (this._flag) {
            throw new IllegalStateException("Cannot clear the map: unmodifiable map already accessed,");
        }
        this._map.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this._map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this._map.entrySet());
    }

    public String toString() {
        return this._map.toString();
    }
}

